package com.digiwin.dap.middle.database.encrypt.model;

/**
 * @author michael
 */
public class ObjectRelationalMapping {

    /*
     * 数据库表名
     */
    private String tableName;

    /*
     * 数据库表字段名
     */
    private String databaseColumnName;

    /*
     * 数据库表字段别名,没有别名默认使用表字段名
     */
    private String objectPropertyName;

    public ObjectRelationalMapping() {
    }

    public ObjectRelationalMapping(String tableName, String databaseColumnName, String objectPropertyName) {
        this.tableName = tableName;
        this.databaseColumnName = databaseColumnName;
        this.objectPropertyName = objectPropertyName;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getObjectPropertyName() {
        return objectPropertyName;
    }

    public void setObjectPropertyName(String objectPropertyName) {
        this.objectPropertyName = objectPropertyName;
    }

    public String getDatabaseColumnName() {
        return databaseColumnName;
    }

    public void setDatabaseColumnName(String databaseColumnName) {
        this.databaseColumnName = databaseColumnName;
    }

    @Override
    public String toString() {
        return tableName + "." + databaseColumnName + " as " + objectPropertyName;
    }
}
