/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dict.service.impl;

import com.digiwin.dap.middleware.dict.domain.DictDTO;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.mapper.DictDataMapper;
import com.digiwin.dap.middleware.dict.mapper.DictMapper;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.digiwin.dap.middleware.util.TokenUtils;
import com.github.pagehelper.PageSerializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class DictServiceImpl
implements DictService {
    @Autowired
    private DictMapper dictMapper;
    @Autowired
    private DictDataMapper dictDataMapper;

    @Override
    public Dict selectDictBySid(Long sid) {
        return this.dictMapper.selectDict(new DictDTO(sid, null));
    }

    @Override
    public Dict selectDictById(String id) {
        return this.dictMapper.selectDict(new DictDTO(null, id));
    }

    @Override
    public Dict selectDict(DictDTO dto) {
        return this.dictMapper.selectDict(dto);
    }

    @Override
    public List<Dict> selectDictList(DictDTO dto) {
        return this.dictMapper.selectDictList(Optional.ofNullable(dto).orElse(new DictDTO()));
    }

    @Override
    public PageSerializable<Dict> selectDictList(DictDTO dto, int pageNum, int pageSize, String orderBy) {
        return PageSerializable.of(this.dictMapper.selectDictList(Optional.ofNullable(dto).orElse(new DictDTO()), pageNum, pageSize, orderBy));
    }

    @Override
    public int insertDict(Dict dict) {
        Dict exists = this.selectDictById(dict.getId());
        Assert.isNull((Object)((Object)exists), (String)String.format("\u5b57\u5178id[%s]\u5df2\u5b58\u5728", dict.getId()));
        TokenUtils.setCreateFields((BaseEntity)dict);
        dict.setSid(SnowFlake.getInstance().newId());
        return this.dictMapper.insertDict(dict);
    }

    @Override
    public int updateDict(Dict dict) {
        Dict exists = this.selectDictById(dict.getId());
        Assert.isTrue((exists == null || dict.getSid() == exists.getSid() ? 1 : 0) != 0, (String)String.format("\u5b57\u5178id[%s]\u5df2\u5b58\u5728", dict.getId()));
        TokenUtils.setModifyFields((BaseEntity)dict);
        return this.dictMapper.updateDict(dict);
    }

    @Override
    public int deleteDictByIds(Collection<Long> sids) {
        return this.dictMapper.deleteDictBySids(sids);
    }

    @Override
    @Transactional
    public int deleteDictBySid(Long sid) {
        Dict dict = this.selectDictBySid(sid);
        Optional.ofNullable(dict).ifPresent(x -> this.dictDataMapper.deleteDictDataByDictId(x.getId()));
        return this.dictMapper.deleteDictBySids(Collections.singletonList(sid));
    }
}

