/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dict.api;

import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.domain.StdData;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/${spring.application.name}/v2/dict/data"})
public class DictDataController {
    @Autowired
    private DictDataService dictDataService;

    @PostMapping(value={"/add"})
    public StdData<Integer> saveDictData(@RequestBody DictDataDTO dto) {
        Assert.hasText((String)dto.getDictId(), (String)"\u5b57\u5178id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getDictKey(), (String)"\u5b57\u5178key\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getDictValue(), (String)"\u5b57\u5178\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        return StdData.ofSuccess((Object)this.dictDataService.insertDictData((DictData)((Object)dto.doForward())));
    }

    @PostMapping(value={"/mod"})
    public StdData<Integer> updateDictData(@RequestBody DictDataDTO dto) {
        Assert.notNull((Object)dto.getSid(), (String)"sid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getDictId(), (String)"\u5b57\u5178id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getDictKey(), (String)"\u5b57\u5178\u9879\u6587\u672c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getDictValue(), (String)"\u5b57\u5178\u9879\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        return StdData.ofSuccess((Object)this.dictDataService.updateDictData((DictData)((Object)dto.doForward())));
    }

    @PostMapping(value={"/del"})
    public StdData<Integer> deleteDictData(@RequestBody DictDataDTO dto) {
        Assert.notNull((Object)dto.getSid(), (String)"\u5b57\u5178\u6570\u636esid\u4e0d\u80fd\u4e3a\u7a7a");
        return StdData.ofSuccess((Object)this.dictDataService.deleteDictDataBySid(dto.getSid()));
    }

    @PostMapping(value={"/find"})
    public StdData<DictData> findDictData(@RequestBody DictDataDTO dto) {
        Assert.isTrue((dto.getSid() != null || StringUtils.hasLength((String)dto.getDictId()) && StringUtils.hasLength((String)dto.getDictKey()) ? 1 : 0) != 0, (String)"\u5b57\u5178sid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((dto.getSid() != null || StringUtils.hasLength((String)dto.getDictId()) ? 1 : 0) != 0, (String)"\u5b57\u5178id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((dto.getSid() != null || StringUtils.hasLength((String)dto.getDictKey()) ? 1 : 0) != 0, (String)"\u5b57\u5178key\u4e0d\u80fd\u4e3a\u7a7a");
        return StdData.ofSuccess((Object)((Object)this.dictDataService.selectDictData(dto)));
    }

    @PostMapping(value={"/exists"})
    public StdData<Boolean> existsDict(@RequestBody DictDataDTO dto) {
        Assert.hasText((String)dto.getDictId(), (String)"\u5b57\u5178id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getDictKey(), (String)"\u5b57\u5178key\u4e0d\u80fd\u4e3a\u7a7a");
        return StdData.ofSuccess((Object)Optional.ofNullable(this.dictDataService.selectDictData(dto)).isPresent());
    }

    @PostMapping(value={"/search"})
    public StdData<PageSerializable<DictData>> searchDictData(@RequestBody DictDataDTO dto) {
        return StdData.ofSuccess(this.dictDataService.selectDictDataList(dto, dto.getPageNum(), dto.getPageSize(), Optional.ofNullable(dto.getOrderBy()).orElse("dd.dict_sort")));
    }

    @PostMapping(value={"/list"})
    public StdData<List<DictData>> listDictData(@RequestBody DictDataDTO dto) {
        return StdData.ofSuccess(this.dictDataService.selectDictDataList(dto));
    }
}

