package com.digiwin.dap.middleware.dict.service;

import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.github.pagehelper.PageSerializable;

import java.util.Collection;
import java.util.List;

/**
 * 字典数据Service接口
 *
 * @author chenzhuang
 * @date 2022-09-05
 */
public interface DictDataService {
    /**
     * 查询字典数据
     *
     * @param sid 字典数据ID
     * @return 字典数据
     */
    DictData selectDictDataBySid(Long sid);

    /**
     * 查询字典数据
     *
     * @param dto 字典数据ID
     * @return 字典数据
     */
    DictData selectDictData(DictDataDTO dto);

    /**
     * 查询字典数据列表
     *
     * @param dto 字典数据
     * @return 字典数据集合
     */
    List<DictData> selectDictDataList(DictDataDTO dto);

    /**
     * 查询字典数据列表[分页]
     *
     * @param dto      字典数据DTO
     * @param pageNum  the page num
     * @param pageSize the page size
     * @param orderBy  the order by
     * @return 字典数据集合 list
     */
    PageSerializable<DictData> selectDictDataList(DictDataDTO dto, Integer pageNum, Integer pageSize, String orderBy);

    /**
     * 新增字典数据
     *
     * @param dictData 字典数据
     * @return 结果
     */
    int insertDictData(DictData dictData);

    /**
     * 修改字典数据
     *
     * @param dictData 字典数据
     * @return 结果
     */
    int updateDictData(DictData dictData);

    /**
     * 批量删除字典数据
     *
     * @param sids 需要删除的数据ID
     * @return 结果
     */
    int deleteDictDataBySids(Collection<Long> sids);

    /**
     * 删除字典数据信息
     *
     * @param sid 字典数据ID
     * @return 结果
     */
    int deleteDictDataBySid(Long sid);
}
