package com.digiwin.dap.middleware.dict.domain;


import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.domain.AbstractConverter;

import java.util.Optional;

/**
 * 字典数据表DTO
 *
 * @author chenzhuang
 * @since 2022-09-02 13:47:53
 */
public class DictDataDTO extends AbstractConverter<DictData> {
    /**
     * sid
     */
    private Long sid;
    /**
     * 字典id
     */
    private String dictId;
    /**
     * 字典key
     */
    private String dictKey;
    /**
     * 字典值
     */
    private String dictValue;
    /**
     * 字典排序
     */
    private Integer dictSort;
    /**
     * 说明描述
     */
    private String remark;
    /**
     * id或者名称
     */
    private String content;

    /**
     * 页码，从1开始
     */
    private Integer pageNum;
    /**
     * 页面大小，默认10
     */
    private Integer pageSize;
    /**
     * 排序
     */
    private String orderBy;

    public DictDataDTO() {
    }

    public DictDataDTO(String dictId, String dictKey) {
        this.dictId = dictId;
        this.dictKey = dictKey;
    }

    public DictDataDTO(Long sid) {
        this.sid = sid;
    }

    public Long getSid() {
        return sid;
    }

    public void setSid(Long sid) {
        this.sid = sid;
    }

    public String getDictId() {
        return dictId;
    }

    public void setDictId(String dictId) {
        this.dictId = dictId;
    }

    public String getDictValue() {
        return dictValue;
    }

    public void setDictValue(String dictValue) {
        this.dictValue = dictValue;
    }

    public String getDictKey() {
        return dictKey;
    }

    public void setDictKey(String dictKey) {
        this.dictKey = dictKey;
    }

    public Integer getDictSort() {
        return dictSort;
    }

    public void setDictSort(Integer dictSort) {
        this.dictSort = dictSort;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getPageNum() {
        return Optional.ofNullable(pageNum).orElse(1);
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return Optional.ofNullable(pageSize).orElse(10);
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}

