/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dict.api;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.dict.domain.DictDTO;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.util.AssertUtils;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/${spring.application.name}/v2/dict"})
public class DictController {
    @Autowired
    private DictService dictService;

    @PostMapping(value={"/add"})
    public StdData<Integer> saveDict(@RequestBody DictDTO dto) {
        AssertUtils.paramHasText((String)dto.getId(), (String)"id");
        AssertUtils.paramHasText((String)dto.getName(), (String)"name");
        return StdData.ok((Object)this.dictService.insertDict((Dict)((Object)dto.doForward())));
    }

    @PostMapping(value={"/mod"})
    public StdData<Integer> updateDict(@RequestBody DictDTO dto) {
        AssertUtils.paramNotNull((Object)dto.getSid(), (String)"sid");
        AssertUtils.paramHasText((String)dto.getId(), (String)"id");
        AssertUtils.paramHasText((String)dto.getName(), (String)"name");
        return StdData.ok((Object)this.dictService.updateDict((Dict)((Object)dto.doForward())));
    }

    @PostMapping(value={"/del"})
    public StdData<Integer> deleteDict(@RequestBody DictDTO dto) {
        AssertUtils.paramNotNull((Object)dto.getSid(), (String)"sid");
        return StdData.ok((Object)this.dictService.deleteDictBySid(dto.getSid()));
    }

    @PostMapping(value={"/find"})
    public StdData<Dict> findDict(@RequestBody DictDTO dto) {
        AssertUtils.isTrue((dto.getSid() != null || StrUtils.isNotEmpty((String)dto.getId()) ? 1 : 0) != 0, (ErrorHandler)CommonErrorCode.PARAM_ALL_EMPTY, (Object[])new Object[]{"sid", "id"});
        return StdData.ok((Object)((Object)this.dictService.selectDict(dto)));
    }

    @PostMapping(value={"/exists"})
    public StdData<Boolean> existsDict(@RequestBody DictDTO dto) {
        AssertUtils.paramHasText((String)dto.getId(), (String)"id");
        return StdData.ok((Object)Optional.ofNullable(this.dictService.selectDictById(dto.getId())).isPresent());
    }

    @PostMapping(value={"/search"})
    public StdData<PageSerializable<Dict>> searchDict(@RequestBody DictDTO dto) {
        return StdData.ok(this.dictService.selectDictList(dto, dto.getPageNum(), dto.getPageSize(), dto.getOrderBy()));
    }

    @PostMapping(value={"/list"})
    public StdData<List<Dict>> listDict(@RequestBody DictDTO dto) {
        return StdData.ok(this.dictService.selectDictList(dto));
    }
}

