package com.digiwin.dap.middleware.dict.mapper;

import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.DictData;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

/**
 * 字典数据Mapper接口
 *
 * @author chenzhuang
 * @date 2022-09-05
 */
@Repository
public interface DictDataMapper {

    /**
     * 查询字典数据
     *
     * @param dto DictDataDTO
     * @return 字典数据
     */
    DictData selectDictData(@Param("dto") DictDataDTO dto);

    /**
     * 查询字典数据列表
     *
     * @param dto 字典数据DTO
     * @return 字典数据集合 list
     */
    List<DictData> selectDictDataList(@Param("dto") DictDataDTO dto);

    /**
     * 查询字典数据列表[分页]
     *
     * @param dto      字典数据DTO
     * @param pageNum  the page num
     * @param pageSize the page size
     * @param orderBy  the order by
     * @return the list
     */
    List<DictData> selectDictDataList(@Param("dto") DictDataDTO dto, @Param("pageNum") Integer pageNum, @Param("pageSize") Integer pageSize, @Param("orderBy") String orderBy);

    /**
     * 新增字典数据
     *
     * @param dictData 字典数据
     * @return 结果
     */
    int insertDictData(DictData dictData);

    /**
     * 修改字典数据
     *
     * @param dictData 字典数据
     * @return 结果
     */
    int updateDictData(DictData dictData);

    /**
     * 删除字典数据
     *
     * @param dictId 字典id
     * @return 结果
     */
    int deleteDictDataByDictId(String dictId);

    /**
     * 批量删除字典数据
     *
     * @param sids 需要删除的数据ID
     * @return 结果
     */
    int deleteDictDataBySids(Collection<Long> sids);
}
