package com.digiwin.dap.middleware.dict.domain;


import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.domain.AbstractConverter;

import java.util.Optional;

/**
 * 字典类型表DTO
 *
 * @author chenzhuang
 * @since 2022-09-02 13:47:53
 */
public class DictDTO extends AbstractConverter<Dict> {
    /**
     * 字典sid
     */
    private Long sid;
    /**
     * 字典id
     */
    private String id;
    /**
     * 字典名称
     */
    private String name;
    /**
     * 说明描述
     */
    private String remark;
    /**
     * id或者名称
     */
    private String content;
    /**
     * 页码，从1开始
     */
    private Integer pageNum;
    /**
     * 页面大小，默认10
     */
    private Integer pageSize ;
    /**
     * 排序
     */
    private String orderBy;

    public DictDTO() {
    }

    public DictDTO(Long sid, String id) {
        this.sid = sid;
        this.id = id;
    }

    public Long getSid() {
        return sid;
    }

    public void setSid(Long sid) {
        this.sid = sid;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getPageNum() {
        return Optional.ofNullable(pageNum).orElse(1);
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return Optional.ofNullable(pageSize).orElse(10);
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}

