package com.digiwin.dap.middleware.dict.constant.enums;

/**
 * 字典类型枚举
 *
 * @author chenzhuang
 * @date 2022-9-14 11:00:27
 */
public enum DictEnum {
    /**
     * 团队类型
     */
    TEAM("team", "团队类型", "iam", "租户的团队类型"),
    /**
     * 来源类型
     */
    SOURCE_TYPE("source_type", "来源类型", "iam", "租户、用户的来源类型"),

    /**
     * 商品类别
     */
    GOODS("goods", "商品类别", "gmc", "商品类别维护"),
    /**
     * 公司别
     */
    COMPANY("company", "公司别", "gmc", "用于和资管对接的公司别维护"),
    /**
     * 试用来源
     */
    TRIAL_SOURCE("trialSource", "试用来源", "gmc", "商品的试用来源，如何得知试用信息"),
    /**
     * 平台类型
     */
    PLATFORM("platform","集成平台类型","cam","集成平台类型,用于维护第三方集成平台应用映射数据")
    ;

    private final String id;
    private final String name;
    private final String project;
    private final String describe;

    DictEnum(String value, String name, String project, String describe) {
        this.id = value;
        this.name = name;
        this.project = project;
        this.describe = describe;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static String getName(String id) {
        if (id == null) {
            return "";
        }
        for (DictEnum objEnum : DictEnum.values()) {
            if (objEnum.getId().equals(id)) {
                return objEnum.name;
            }
        }
        return "";
    }

    public static String getProject(String id) {
        if (id == null) {
            return "";
        }
        for (DictEnum objEnum : DictEnum.values()) {
            if (objEnum.getId().equals(id)) {
                return objEnum.project;
            }
        }
        return "";
    }

    public static String getDescribe(String id) {
        if (id == null) {
            return "";
        }
        for (DictEnum objEnum : DictEnum.values()) {
            if (objEnum.getId().equals(id)) {
                return objEnum.describe;
            }
        }
        return "";
    }

    public static boolean contains(String id) {
        for (DictEnum objEnum : DictEnum.values()) {
            if (objEnum.getId().equals(id)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return "DictEnum{" +
                "value='" + id + '\'' +
                ", name='" + name + '\'' +
                ", describe='" + describe + '\'' +
                '}';
    }
}
