/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dict.api;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.dict.domain.DictDataDTO;
import com.digiwin.dap.middleware.dict.entity.DictData;
import com.digiwin.dap.middleware.dict.service.DictDataService;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.util.AssertUtils;
import com.github.pagehelper.PageSerializable;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/${spring.application.name}/v2/dict/data"})
public class DictDataController {
    @Autowired
    private DictDataService dictDataService;

    @PostMapping(value={"/add"})
    public StdData<Integer> saveDictData(@RequestBody DictDataDTO dto) {
        AssertUtils.paramHasText((String)dto.getDictId(), (String)"dictId");
        AssertUtils.paramHasText((String)dto.getDictKey(), (String)"dictKey");
        AssertUtils.paramHasText((String)dto.getDictValue(), (String)"dictValue");
        return StdData.ok((Object)this.dictDataService.insertDictData((DictData)((Object)dto.doForward())));
    }

    @PostMapping(value={"/mod"})
    public StdData<Integer> updateDictData(@RequestBody DictDataDTO dto) {
        AssertUtils.paramNotNull((Object)dto.getSid(), (String)"sid");
        AssertUtils.paramHasText((String)dto.getDictId(), (String)"dictId");
        AssertUtils.paramHasText((String)dto.getDictKey(), (String)"dictKey");
        AssertUtils.paramHasText((String)dto.getDictValue(), (String)"dictValue");
        return StdData.ok((Object)this.dictDataService.updateDictData((DictData)((Object)dto.doForward())));
    }

    @PostMapping(value={"/del"})
    public StdData<Integer> deleteDictData(@RequestBody DictDataDTO dto) {
        AssertUtils.paramNotNull((Object)dto.getSid(), (String)"sid");
        return StdData.ok((Object)this.dictDataService.deleteDictDataBySid(dto.getSid()));
    }

    @PostMapping(value={"/find"})
    public StdData<DictData> findDictData(@RequestBody DictDataDTO dto) {
        AssertUtils.isTrue((dto.getSid() != null || StrUtils.isNotEmpty((String)dto.getDictId()) && StrUtils.isNotEmpty((String)dto.getDictKey()) ? 1 : 0) != 0, (ErrorHandler)CommonErrorCode.PARAM_EMPTY, (Object[])new Object[]{"sid"});
        AssertUtils.isTrue((dto.getSid() != null || StrUtils.isNotEmpty((String)dto.getDictId()) ? 1 : 0) != 0, (ErrorHandler)CommonErrorCode.PARAM_EMPTY, (Object[])new Object[]{"id"});
        AssertUtils.isTrue((dto.getSid() != null || StrUtils.isNotEmpty((String)dto.getDictKey()) ? 1 : 0) != 0, (ErrorHandler)CommonErrorCode.PARAM_EMPTY, (Object[])new Object[]{"key"});
        return StdData.ok((Object)((Object)this.dictDataService.selectDictData(dto)));
    }

    @PostMapping(value={"/exists"})
    public StdData<Boolean> existsDict(@RequestBody DictDataDTO dto) {
        AssertUtils.paramHasText((String)dto.getDictId(), (String)"dictId");
        AssertUtils.paramHasText((String)dto.getDictKey(), (String)"dictKey");
        return StdData.ok((Object)Optional.ofNullable(this.dictDataService.selectDictData(dto)).isPresent());
    }

    @PostMapping(value={"/search"})
    public StdData<PageSerializable<DictData>> searchDictData(@RequestBody DictDataDTO dto) {
        return StdData.ok(this.dictDataService.selectDictDataList(dto, dto.getPageNum(), dto.getPageSize(), Optional.ofNullable(dto.getOrderBy()).orElse("dd.dict_sort")));
    }

    @PostMapping(value={"/list"})
    public StdData<List<DictData>> listDictData(@RequestBody DictDataDTO dto) {
        return StdData.ok(this.dictDataService.selectDictDataList(dto));
    }
}

