/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dict.service.impl;

import com.digiwin.dap.middleware.dict.domain.DictDTO;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.digiwin.dap.middleware.dict.mapper.DictDataMapper;
import com.digiwin.dap.middleware.dict.mapper.DictMapper;
import com.digiwin.dap.middleware.dict.service.DictService;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.util.AssertUtils;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.github.pagehelper.PageSerializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictServiceImpl
implements DictService {
    @Autowired
    private DictMapper dictMapper;
    @Autowired
    private DictDataMapper dictDataMapper;

    @Override
    public Dict selectDictBySid(Long sid) {
        return this.dictMapper.selectDict(new DictDTO(sid, null));
    }

    @Override
    public Dict selectDictById(String id) {
        return this.dictMapper.selectDict(new DictDTO(null, id));
    }

    @Override
    public Dict selectDict(DictDTO dto) {
        return this.dictMapper.selectDict(dto);
    }

    @Override
    public List<Dict> selectDictList(DictDTO dto) {
        return this.dictMapper.selectDictList(Optional.ofNullable(dto).orElse(new DictDTO()));
    }

    @Override
    public PageSerializable<Dict> selectDictList(DictDTO dto, int pageNum, int pageSize, String orderBy) {
        return PageSerializable.of(this.dictMapper.selectDictList(Optional.ofNullable(dto).orElse(new DictDTO()), pageNum, pageSize, orderBy));
    }

    @Override
    public int insertDict(Dict dict) {
        Dict exists = this.selectDictById(dict.getId());
        AssertUtils.valueIsNull((Object)((Object)exists), (String)dict.getId());
        EntityUtils.setCreateFields((BaseEntity)dict);
        dict.setSid(SnowFlake.getInstance().newId());
        return this.dictMapper.insertDict(dict);
    }

    @Override
    public int updateDict(Dict dict) {
        Dict exists = this.selectDictById(dict.getId());
        AssertUtils.isTrue((exists == null || dict.getSid() == exists.getSid() ? 1 : 0) != 0, (ErrorHandler)CommonErrorCode.VALUE_EXISTS, (Object[])new Object[]{dict.getId()});
        EntityUtils.setModifyFields((BaseEntity)dict);
        return this.dictMapper.updateDict(dict);
    }

    @Override
    public int deleteDictByIds(Collection<Long> sids) {
        return this.dictMapper.deleteDictBySids(sids);
    }

    @Override
    @Transactional
    public int deleteDictBySid(Long sid) {
        Dict dict = this.selectDictBySid(sid);
        Optional.ofNullable(dict).ifPresent(x -> this.dictDataMapper.deleteDictDataByDictId(x.getId()));
        return this.dictMapper.deleteDictBySids(Collections.singletonList(sid));
    }
}

