package com.digiwin.dap.middleware.dict.mapper;

import com.digiwin.dap.middleware.dict.domain.DictDTO;
import com.digiwin.dap.middleware.dict.entity.Dict;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

/**
 * 字典类型Mapper接口
 *
 * @author chenzhuang
 * @date 2022-09-05
 */
@Repository
public interface DictMapper {
    /**
     * 查询字典类型
     *
     * @param dto 字典类型DTO
     * @return 字典类型
     */
    Dict selectDict(@Param("dto") DictDTO dto);

    /**
     * 查询字典类型列表
     *
     * @param dto 字典类型DTO
     * @return 字典类型集合
     */
    List<Dict> selectDictList(@Param("dto") DictDTO dto);

    /**
     * 查询字典类型列表[分页]
     *
     * @param dto 字典类型DTO
     * @return 字典类型集合
     */
    List<Dict> selectDictList(@Param("dto") DictDTO dto, @Param("pageNum") int pageNum, @Param("pageSize") int pageSize, @Param("orderBy") String orderBy);

    /**
     * 新增字典类型
     *
     * @param dict 字典类型
     * @return 结果
     */
    int insertDict(Dict dict);

    /**
     * 修改字典类型
     *
     * @param dict 字典类型
     * @return 结果
     */
    int updateDict(Dict dict);

    /**
     * 批量删除字典类型
     *
     * @param sids 需要删除的数据ID
     * @return 结果
     */
    int deleteDictBySids(Collection<Long> sids);
}
