package com.digiwin.dap.middleware.dict.service;

import com.digiwin.dap.middleware.dict.domain.DictDTO;
import com.digiwin.dap.middleware.dict.entity.Dict;
import com.github.pagehelper.PageSerializable;

import java.util.Collection;
import java.util.List;

/**
 * 字典类型Service接口
 *
 * @author chenzhuang
 * @date 2022-09-05
 */
public interface DictService {
    /**
     * 查询字典类型信息
     *
     * @param sid the sid
     * @return 结果
     */
    Dict selectDictBySid(Long sid);

    /**
     * 查询字典类型信息
     *
     * @param id the id
     * @return 结果
     */
    Dict selectDictById(String id);

    /**
     * 查询字典类型信息
     *
     * @param dto the dto
     * @return the dict
     */
    Dict selectDict(DictDTO dto);

    /**
     * 查询字典类型列表
     *
     * @param dto DictDTO
     * @return 字典类型集合 list
     */
    List<Dict> selectDictList(DictDTO dto);

    /**
     * 查询字典类型[分页]
     *
     * @param dto      DictDTO
     * @param pageNum  the page num
     * @param pageSize the page size
     * @param orderBy  the order by
     * @return the list
     */
    PageSerializable<Dict> selectDictList(DictDTO dto, int pageNum, int pageSize, String orderBy);

    /**
     * 新增字典类型
     *
     * @param dict 字典类型
     * @return 结果
     */
    int insertDict(Dict dict);

    /**
     * 修改字典类型
     *
     * @param dict 字典类型
     * @return 结果
     */
    int updateDict(Dict dict);

    /**
     * 批量删除字典类型
     *
     * @param sids 需要删除的数据IDs
     * @return 结果
     */
    int deleteDictByIds(Collection<Long> sids);

    /**
     * 删除字典类型信息
     *
     * @param sid 字典类型ID
     * @return 结果
     */
    int deleteDictBySid(Long sid);
}
