/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.encrypt.config;

import com.digiwin.dap.middle.encrypt.domain.StdDataEncrypt;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapEncrypt;
import com.digiwin.dap.middle.encrypt.domain.annotation.DapSign;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.SignUtils;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.util.JsonUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class EncryptResponse
implements ResponseBodyAdvice<StdData> {
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return returnType.hasMethodAnnotation(DapEncrypt.class) || AnnotationUtils.findAnnotation((Class)returnType.getDeclaringClass(), DapEncrypt.class) != null || returnType.hasMethodAnnotation(DapSign.class) || AnnotationUtils.findAnnotation((Class)returnType.getDeclaringClass(), DapSign.class) != null;
    }

    public StdData<?> beforeBodyWrite(StdData body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body == null || body.getData() == null) {
            return body;
        }
        HttpServletRequest req = ((ServletServerHttpRequest)request).getServletRequest();
        if (Boolean.TRUE.equals(req.getAttribute("encryptStatus"))) {
            DapEncrypt dapEncrypt = (DapEncrypt)AnnotationUtils.findAnnotation((Class)returnType.getDeclaringClass(), DapEncrypt.class);
            if (dapEncrypt == null) {
                dapEncrypt = (DapEncrypt)returnType.getMethodAnnotation(DapEncrypt.class);
            }
            if (dapEncrypt != null && dapEncrypt.responseEncrypt()) {
                String appSecret = (String)req.getAttribute("appSecret");
                String dataString = BeanUtils.isSimpleProperty(body.getData().getClass()) ? body.getData().toString() : JsonUtils.objToJson((Object)body.getData());
                String eData = AES.encryptIvCBC((String)dataString, (String)appSecret);
                body.setData(eData);
            }
        }
        if (Boolean.TRUE.equals(req.getAttribute("signStatus"))) {
            DapSign dapSign = (DapSign)AnnotationUtils.findAnnotation((Class)returnType.getDeclaringClass(), DapSign.class);
            if (dapSign == null) {
                dapSign = (DapSign)returnType.getMethodAnnotation(DapSign.class);
            }
            if (dapSign != null && dapSign.responseSign()) {
                StdDataEncrypt dataEncrypt = new StdDataEncrypt();
                dataEncrypt.setCode(body.getCode());
                dataEncrypt.setMessage(body.getMessage());
                dataEncrypt.setSuccess(body.isSuccess());
                dataEncrypt.setData(body.getData());
                String appSecret = (String)req.getAttribute("appSecret");
                String dataString = BeanUtils.isSimpleProperty(body.getData().getClass()) ? body.getData().toString() : SignUtils.sortParam((Object)body.getData());
                String sign = SignUtils.sign((String)appSecret, (String)dataString);
                dataEncrypt.setSign(sign);
                body = dataEncrypt;
            }
        }
        return body;
    }
}

