package com.digiwin.dap.middle.gateway.service.track.web;


import com.digiwin.dap.middle.gateway.service.track.http.HttpTrack;
import com.digiwin.dap.middle.gateway.service.track.http.HttpTrackRepository;
import com.digiwin.dap.middle.gateway.service.track.http.TraceableRequest;
import com.digiwin.dap.middle.gateway.service.track.http.TraceableResponse;
import com.digiwin.dap.middleware.domain.FilterOrderEnum;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

/**
 * http请求拦截器
 *
 * @author fobgochod
 * @date 2019/12/18
 */
public class HttpTrackFilter extends OncePerRequestFilter implements Ordered {

    private final HttpTrackRepository repository;

    public HttpTrackFilter(HttpTrackRepository repository) {
        this.repository = repository;
    }

    @Override
    public int getOrder() {
        return FilterOrderEnum.ACCESS_LOG.order();
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!isRequestValid(request)) {
            filterChain.doFilter(request, response);
            return;
        }
        TraceableRequest traceableRequest = new TraceableHttpServletRequest(request);
        HttpTrack track = new HttpTrack(traceableRequest);
        int status = HttpStatus.INTERNAL_SERVER_ERROR.value();
        try {
            filterChain.doFilter(request, response);
            status = response.getStatus();
        } finally {
            TraceableResponse traceableResponse = new TraceableHttpServletResponse(response);
            track.afterPropertiesSet();
            track.setResponse(new HttpTrack.Response(traceableResponse, status));
            this.repository.add(track);
        }
    }

    private boolean isRequestValid(HttpServletRequest request) {
        try {
            new URI(request.getRequestURL().toString());
            return true;
        } catch (URISyntaxException ex) {
            return false;
        }
    }
}
