/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.gateway.service.log;

import com.digiwin.dap.middleware.constant.DapHttpHeaders;
import com.digiwin.dap.middleware.lmc.LMC;
import com.digiwin.dap.middleware.lmc.request.SaveEventLog;
import com.digiwin.dap.middleware.util.UserUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class DapLoggingInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(DapLoggingInterceptor.class);
    private final String appName;
    private final LMC lmcClient;

    public DapLoggingInterceptor(String appName, LMC lmcClient) {
        this.appName = appName;
        this.lmcClient = lmcClient;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        String errorMsg = null;
        try {
            ClientHttpResponse response = execution.execute(request, body);
            if (response.getStatusCode().isError()) {
                errorMsg = response.getStatusCode().toString();
            }
            ClientHttpResponse clientHttpResponse = response;
            return clientHttpResponse;
        }
        catch (IOException e) {
            errorMsg = e.getMessage();
            throw e;
        }
        finally {
            if (errorMsg != null) {
                this.logRequestEx(request, body, errorMsg);
            }
        }
    }

    public void logRequestEx(HttpRequest request, byte[] body, String errorMsg) {
        try {
            SaveEventLog eventLog = new SaveEventLog();
            eventLog.setAppId("coremiddleware");
            eventLog.setEventSource(this.appName);
            eventLog.setEventType(Integer.valueOf(99));
            eventLog.setEventId("INTERNAL_SERVICE_CALL");
            eventLog.setEventName("\u5185\u90e8\u670d\u52a1\u8c03\u7528");
            eventLog.setUserId(UserUtils.getUserId());
            eventLog.setUserName(UserUtils.getUserName());
            eventLog.setTenantId(UserUtils.getTenantId());
            eventLog.setTenantName(UserUtils.getTenantName());
            eventLog.setSysId(UserUtils.getSysId());
            eventLog.setStatus(Integer.valueOf(1));
            eventLog.setErrorMsg(errorMsg);
            eventLog.setMethod(request.getMethodValue());
            eventLog.setRequestUrl(request.getURI().getPath());
            eventLog.setRequestParam(request.getURI().getQuery());
            LinkedHashMap<String, Object> contents = new LinkedHashMap<String, Object>();
            contents.put("uri", request.getURI());
            contents.put("method", request.getMethod());
            contents.put("headers", this.extractHeaders(request));
            contents.put("requestBody", new String(body, StandardCharsets.UTF_8));
            eventLog.setContent(contents);
            this.lmcClient.saveEventLog(eventLog);
        }
        catch (Exception ex) {
            logger.error("\u8bb0\u5f55\u5185\u90e8\u8c03\u7528\u5f02\u5e38", (Throwable)ex);
        }
    }

    private Map<String, String> extractHeaders(HttpRequest request) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        request.getHeaders().forEach((key, value) -> {
            if (DapHttpHeaders.contains((String)key)) {
                headers.put((String)key, (String)value.get(0));
            }
        });
        return headers;
    }
}

