package com.digiwin.dap.middle.gateway.service.track.http;

import java.util.List;

/**
 * http请求统计
 *
 * @author fobgochod
 * @date 2019/12/18
 */
public interface HttpTrackRepository {

    /**
     * Find all {@link HttpTrack} objects contained in the repository.
     *
     * @return the results
     */
    List<HttpTrack> findAll();

    /**
     * Adds a trace to the repository.
     *
     * @param trace the trace to add
     */
    void add(HttpTrack trace);

    /**
     * Retrieves and remove all, or returns {@code null} if this is empty.
     *
     * @return
     */
    List<HttpTrack> getAll();
}
