/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.gateway;

import com.digiwin.dap.middle.gateway.HttpTrackExecutorConfiguration;
import com.digiwin.dap.middle.gateway.constant.GatewayConstants;
import com.digiwin.dap.middle.gateway.service.track.http.HttpTrackRepository;
import com.digiwin.dap.middle.gateway.service.track.web.HttpTrackFilter;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.lmc.LMC;
import com.digiwin.dap.middleware.lmc.LMCClient;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;

@AutoConfiguration
@ComponentScan(basePackages={"com.digiwin.dap.middle.gateway"})
@ConditionalOnProperty(name={"dap.middleware.access-log"}, havingValue="true")
@ConditionalOnExpression(value="#{T(org.springframework.util.StringUtils).hasLength(environment.getProperty('dap.middleware.lmc.svc.uri'))}")
@Import(value={HttpTrackExecutorConfiguration.class})
public class HttpTrackConfiguration {
    @Autowired
    private DapEnv dapEnv;
    @Value(value="${dap.middleware.lmc.svc.uri:}")
    private String lmcSvcUri;

    @Bean(name={"gwLmcClient"})
    public LMC gwLmcClient() {
        return new LMCClient(this.lmcSvcUri, "crstatscenter", this.dapEnv.getAppToken(), this.dapEnv.getAppSecret());
    }

    @Bean
    @ConditionalOnMissingBean(name={"httpTrackFilter"})
    public FilterRegistrationBean<Filter> httpTrackFilter(HttpTrackRepository repository) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        HttpTrackFilter filter = new HttpTrackFilter(repository);
        registrationBean.setFilter((Filter)filter);
        registrationBean.setOrder(filter.getOrder());
        registrationBean.addUrlPatterns(GatewayConstants.DEFAULT_URL_MAPPINGS);
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }
}

