package com.digiwin.dap.middle.gateway.service.log;

import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.lmc.LMC;
import com.digiwin.dap.middleware.lmc.LMCClient;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

@Component
public class DapLoggingInterceptorConfigurer implements BeanPostProcessor, InitializingBean {

    @Autowired
    private DapEnv dapEnv;
    private DapLoggingInterceptor dapLoggingInterceptor;

    @Override
    public void afterPropertiesSet() throws Exception {
        LMC lmcClient = new LMCClient(dapEnv.getLmcUri(), dapEnv.getAppName(), dapEnv.getAppToken(), dapEnv.getAppSecret());
        this.dapLoggingInterceptor = new DapLoggingInterceptor(dapEnv.getAppName(), lmcClient);
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof RestTemplate) {
            RestTemplate restTemplate = (RestTemplate) bean;
            List<ClientHttpRequestInterceptor> interceptors = restTemplate.getInterceptors();
            interceptors.add(dapLoggingInterceptor);
            restTemplate.setInterceptors(interceptors);
        }
        return bean;
    }
}
