package com.digiwin.dap.middle.gateway.service.track.http;

import com.digiwin.dap.middle.gateway.constant.GatewayConstants;
import com.digiwin.dap.middle.gateway.service.track.LmcHttpTrackService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/**
 * In-memory implementation of {@link HttpTrackRepository}.
 *
 * @author fobgochod
 * @date 2022/11/16 10:54
 */
@Service
public class InMemoryHttpTrackRepository implements HttpTrackRepository {

    private static final Logger logger = LoggerFactory.getLogger(InMemoryHttpTrackRepository.class);
    private final List<HttpTrack> traces = new LinkedList<>();

    @Autowired
    private LmcHttpTrackService lmcHttpTrackService;
    @Qualifier("httpTrackExecutor")
    @Autowired
    private ThreadPoolTaskExecutor httpTrackExecutor;

    @Override
    public List<HttpTrack> findAll() {
        synchronized (this.traces) {
            return Collections.unmodifiableList(new ArrayList<>(this.traces));
        }
    }

    @Override
    public void add(HttpTrack trace) {
        synchronized (this.traces) {
            if (this.traces.size() >= GatewayConstants.HTTP_TRACK_CAPACITY) {
                try {
                    List<HttpTrack> httpTracks = new ArrayList<>(this.traces);
                    httpTrackExecutor.execute(() -> lmcHttpTrackService.save(httpTracks));
                    this.traces.clear();
                } catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
            this.traces.add(trace);
        }
    }

    @Override
    public List<HttpTrack> getAll() {
        synchronized (this.traces) {
            List<HttpTrack> httpTracks = new ArrayList<>(this.traces);
            this.traces.clear();
            return httpTracks;
        }
    }
}
