package com.digiwin.dap.middle.gateway.service.track.web;


import com.digiwin.dap.middle.gateway.service.track.http.TraceableResponse;
import com.digiwin.dap.middleware.constant.DapHttpHeaders;

import jakarta.servlet.http.HttpServletResponse;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * An adapter that exposes an {@link HttpServletResponse} as a {@link TraceableResponse}.
 *
 * @author fobgochod
 * @date 2022/11/17 14:52
 */
final class TraceableHttpServletResponse implements TraceableResponse {

    private final HttpServletResponse delegate;

    TraceableHttpServletResponse(HttpServletResponse response) {
        this.delegate = response;
    }

    @Override
    public int getStatus() {
        return this.delegate.getStatus();
    }

    @Override
    public Map<String, String> getHeaders() {
        return extractHeaders();
    }

    private Map<String, String> extractHeaders() {
        Map<String, String> headers = new LinkedHashMap<>();
        for (String name : this.delegate.getHeaderNames()) {
            if (DapHttpHeaders.contains(name)) {
                headers.put(name, this.delegate.getHeader(name));
            }
        }
        return headers;
    }

}
