/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.gateway.service.track.web;

import com.digiwin.dap.middle.gateway.service.track.http.HttpTrack;
import com.digiwin.dap.middle.gateway.service.track.http.HttpTrackRepository;
import com.digiwin.dap.middle.gateway.service.track.web.TraceableHttpServletRequest;
import com.digiwin.dap.middle.gateway.service.track.web.TraceableHttpServletResponse;
import com.digiwin.dap.middleware.domain.FilterOrderEnum;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.OncePerRequestFilter;

public class HttpTrackFilter
extends OncePerRequestFilter
implements Ordered {
    private final HttpTrackRepository repository;

    public HttpTrackFilter(HttpTrackRepository repository) {
        this.repository = repository;
    }

    public int getOrder() {
        return FilterOrderEnum.ACCESS_LOG.order();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        TraceableHttpServletRequest traceableRequest = new TraceableHttpServletRequest(request);
        HttpTrack track = new HttpTrack(traceableRequest);
        int status = HttpStatus.INTERNAL_SERVER_ERROR.value();
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            status = response.getStatus();
        }
        finally {
            TraceableHttpServletResponse traceableResponse = new TraceableHttpServletResponse(response);
            track.afterPropertiesSet();
            track.setResponse(new HttpTrack.Response(traceableResponse, status));
            this.repository.add(track);
        }
    }
}

