package com.digiwin.dap.middle.gateway.service.track.http;

import java.util.Map;

/**
 * A representation of an HTTP response that is suitable for tracing.
 *
 * @author fobgochod
 * @date 2022/11/17 14:51
 */
public interface TraceableResponse {

    /**
     * The status of the response.
     *
     * @return the status
     */
    int getStatus();

    /**
     * Returns a modifiable copy of the headers of the response.
     *
     * @return the headers
     */
    Map<String, String> getHeaders();

}
