/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.gateway;

import com.digiwin.dap.middle.gateway.constant.GatewayConstants;
import com.digiwin.dap.middle.gateway.service.stats.filter.HttpStatsFilter;
import com.digiwin.dap.middle.gateway.service.stats.interceptor.HttpStatsInterceptor;
import com.digiwin.dap.middleware.domain.DapEnv;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.MappedInterceptor;

@AutoConfiguration
@ConditionalOnProperty(name={"dap.middleware.stats-api"}, havingValue="true")
public class HttpStatsConfiguration {
    @Autowired
    private DapEnv dapEnv;

    @Bean
    @ConditionalOnProperty(name={"spring.redis.host"})
    @ConditionalOnMissingBean(name={"httpStatsFilter"})
    public FilterRegistrationBean<Filter> httpStatsFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        HttpStatsFilter filter = new HttpStatsFilter(this.dapEnv.getAppName());
        registrationBean.setFilter((Filter)filter);
        registrationBean.setOrder(filter.getOrder());
        registrationBean.addUrlPatterns(GatewayConstants.DEFAULT_URL_MAPPINGS);
        return registrationBean;
    }

    @Bean
    @ConditionalOnMissingBean(name={"httpStatsInterceptor"})
    public MappedInterceptor httpStatsInterceptor() {
        HttpStatsInterceptor interceptor = new HttpStatsInterceptor();
        return new MappedInterceptor(GatewayConstants.DEFAULT_PATH_MAPPINGS, (HandlerInterceptor)interceptor);
    }
}

