package com.digiwin.dap.middle.gateway.service.track.web;


import com.digiwin.dap.middle.gateway.service.track.http.HttpTrack;
import com.digiwin.dap.middle.gateway.service.track.http.HttpTrackRepository;
import com.digiwin.dap.middle.gateway.service.track.http.TraceableRequest;
import com.digiwin.dap.middle.gateway.service.track.http.TraceableResponse;
import com.digiwin.dap.middleware.domain.FilterOrderEnum;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.OncePerRequestFilter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * http请求拦截器
 *
 * @author fobgochod
 */
public class HttpTrackFilter extends OncePerRequestFilter implements Ordered {

    private final HttpTrackRepository repository;

    public HttpTrackFilter(HttpTrackRepository repository) {
        this.repository = repository;
    }

    @Override
    public int getOrder() {
        return FilterOrderEnum.ACCESS_LOG.order();
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        TraceableRequest traceableRequest = new TraceableHttpServletRequest(request);
        HttpTrack track = new HttpTrack(traceableRequest);
        int status = HttpStatus.INTERNAL_SERVER_ERROR.value();
        try {
            filterChain.doFilter(request, response);
            status = response.getStatus();
        } finally {
            TraceableResponse traceableResponse = new TraceableHttpServletResponse(response);
            track.afterPropertiesSet();
            track.setResponse(new HttpTrack.Response(traceableResponse, status));
            this.repository.add(track);
        }
    }
}
