package com.digiwin.dap.middle.gateway.service.stats.interceptor;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class HttpStatsInterceptor implements HandlerInterceptor {

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        final RequestInfo requestInfo = AppAuthContextHolder.getContext().getRequestInfo();
        Object path = request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        if (requestInfo != null && path != null) {
            requestInfo.setP((String) path);
        }
        return true;
    }
}
