/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.gateway.service.log;

import com.digiwin.dap.middle.gateway.service.log.DapLoggingInterceptor;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.lmc.LMC;
import com.digiwin.dap.middleware.lmc.LMCClient;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class DapLoggingInterceptorConfigurer
implements BeanPostProcessor,
InitializingBean {
    @Autowired
    private DapEnv dapEnv;
    private DapLoggingInterceptor dapLoggingInterceptor;

    public void afterPropertiesSet() throws Exception {
        LMCClient lmcClient = new LMCClient(this.dapEnv.getLmcUri(), this.dapEnv.getAppName(), this.dapEnv.getAppToken(), this.dapEnv.getAppSecret());
        this.dapLoggingInterceptor = new DapLoggingInterceptor(this.dapEnv.getAppName(), (LMC)lmcClient);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof RestTemplate) {
            RestTemplate restTemplate = (RestTemplate)bean;
            List interceptors = restTemplate.getInterceptors();
            interceptors.add(this.dapLoggingInterceptor);
            restTemplate.setInterceptors(interceptors);
        }
        return bean;
    }
}

