/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ha.service;

import com.digiwin.dap.middle.ha.config.HealthRedisTemplate;
import com.digiwin.dap.middle.ha.domain.HA;
import com.digiwin.dap.middle.ha.domain.Redis;
import com.digiwin.dap.middle.ha.service.RedisConfigService;
import com.digiwin.dap.middle.ha.service.RedisMailService;
import com.digiwin.dap.middleware.domain.DapEnv;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionCommands;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class RedisHealthService
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(RedisHealthService.class);
    private static final HA ha = new HA();
    @Autowired
    private DapEnv dapEnv;
    @Autowired(required=false)
    private RedisMailService redisMailService;
    @Autowired(required=false)
    private RedisConfigService redisConfigService;
    @Autowired(required=false)
    private HealthRedisTemplate healthRedisTemplate;

    @Scheduled(fixedRate=5000L)
    public void execute() {
        logger.debug("Redis\u6545\u969c\u76d1\u63a7\u4e2d...");
        try {
            this.healthRedisTemplate.execute(RedisConnectionCommands::ping);
            this.toMaster();
        }
        catch (Exception e) {
            this.toReplica();
        }
    }

    public void toMaster() {
        if (!this.redisConfigService.isMasterRedis()) {
            logger.info("Redis\u7b2c{}\u6b21\u8bbf\u95ee\u6b63\u5e38\uff0c\u8fde\u7eed{}\u6b21\u6b63\u5e38\u5224\u5b9a\u4e3a\u53ef\u7528\uff0c\u5c06\u81ea\u52a8\u5207\u6362\u56deMaster\u8282\u70b9", (Object)(++HA.OK_COUNT), (Object)3);
            if (HA.OK_COUNT == 1) {
                ha.setNormalDate(LocalDateTime.now());
            }
            if (HA.OK_COUNT >= 3) {
                if (this.redisConfigService.changeHost(this.redisConfigService.master())) {
                    HA.OK_COUNT = 0;
                    logger.warn("Redis\u6062\u590d\u6b63\u5e38\uff0c\u5207\u6362\u56deMaster\u8282\u70b9\uff1a{}", (Object)this.redisConfigService.master());
                    ha.setSwitchDate(LocalDateTime.now());
                    ha.setTip("Redis\u6062\u590d\u6b63\u5e38\uff0c\u5207\u6362\u56deMaster\u8282\u70b9");
                    this.sendMail();
                } else {
                    logger.error("Redis\u7b2c{}\u6b21\u8bbf\u95ee\u6b63\u5e38\uff0c\u5207\u6362\u56deMaster\u8282\u70b9\u5931\u8d25", (Object)HA.OK_COUNT);
                }
            }
        }
        HA.FAIL_COUNT = 0;
    }

    private void sendMail() {
        if (this.redisMailService != null) {
            this.redisMailService.switchRedis(ha);
        }
    }

    private void toReplica() {
        if (this.redisConfigService.isMasterRedis()) {
            logger.info("Redis\u7b2c{}\u6b21\u8bbf\u95ee\u5f02\u5e38\uff0c\u8fde\u7eed{}\u6b21\u5f02\u5e38\u5224\u5b9a\u4e3a\u6545\u969c\uff0c\u5c06\u81ea\u52a8\u5207\u6362\u5230Replica\u8282\u70b9", (Object)(++HA.FAIL_COUNT), (Object)5);
            if (HA.FAIL_COUNT == 1) {
                Redis master = this.redisConfigService.master();
                Redis replica = this.redisConfigService.replica();
                ha.setHost(this.dapEnv.getHost());
                ha.setIp(this.dapEnv.getIpAddress());
                ha.setFailDate(LocalDateTime.now());
                ha.setMasterUrl(String.format("%s:%s", master.getHost(), master.getPort()));
                ha.setReplicaUrl(String.format("%s:%s", replica.getHost(), replica.getPort()));
            }
            if (HA.FAIL_COUNT >= 5) {
                if (!this.replicaOk()) {
                    logger.error("Redis\u7684Replica\u8282\u70b9\u5f02\u5e38\uff0c\u6682\u4e0d\u5207\u6362");
                    return;
                }
                if (this.redisConfigService.changeHost(this.redisConfigService.replica())) {
                    HA.FAIL_COUNT = 0;
                    logger.warn("Redis\u53d1\u751f\u6545\u969c\uff0c\u5207\u6362\u5230Replica\u8282\u70b9\uff1a{}", (Object)this.redisConfigService.replica());
                    ha.setNormalDate(null);
                    ha.setSwitchDate(LocalDateTime.now());
                    ha.setTip("Redis\u53d1\u751f\u6545\u969c\uff0c\u5207\u6362\u5230Replica\u8282\u70b9");
                    this.sendMail();
                } else {
                    logger.error("Redis\u7b2c{}\u6b21\u8bbf\u95ee\u5f02\u5e38\uff0c\u5207\u6362\u5230Replica\u8282\u70b9\u5931\u8d25", (Object)HA.FAIL_COUNT);
                }
            }
        }
        HA.OK_COUNT = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean replicaOk() {
        JedisConnectionFactory redisFactory = new JedisConnectionFactory(this.redisConfigService.getReplicaConfig());
        RedisConnection connection = null;
        try {
            connection = RedisConnectionUtils.getConnection((RedisConnectionFactory)redisFactory);
            boolean bl = Boolean.TRUE;
            return bl;
        }
        catch (Exception e) {
            logger.error("Redis\u7684Replica\u8282\u70b9\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)redisFactory, (boolean)false);
        }
        return Boolean.FALSE;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        try {
            this.redisMailService = (RedisMailService)context.getBean(RedisMailService.class);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }
}

