/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ha;

import com.digiwin.dap.middle.ha.condition.DeployAreaCondition;
import com.digiwin.dap.middle.ha.config.HealthRedisTemplate;
import com.digiwin.dap.middle.ha.config.RedisHealthProperties;
import java.time.Duration;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.JedisPoolConfig;

@AutoConfiguration
@ComponentScan(basePackages={"com.digiwin.dap.middle.ha"})
@Conditional(value={DeployAreaCondition.class})
public class RedisHealthConfiguration {
    @Autowired
    private RedisHealthProperties redisHealthProperties;

    @Bean
    public HealthRedisTemplate healthRedisTemplate() {
        return new HealthRedisTemplate((RedisConnectionFactory)this.createJedisConnectionFactory());
    }

    private JedisConnectionFactory createJedisConnectionFactory() {
        JedisClientConfiguration clientConfiguration = this.getJedisClientConfiguration();
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory(this.getStandaloneConfig(), clientConfiguration);
        jedisConnectionFactory.afterPropertiesSet();
        return jedisConnectionFactory;
    }

    private JedisClientConfiguration getJedisClientConfiguration() {
        JedisClientConfiguration.JedisClientConfigurationBuilder builder = this.applyProperties(JedisClientConfiguration.builder());
        builder.usePooling().poolConfig((GenericObjectPoolConfig)this.jedisPoolConfig());
        return builder.build();
    }

    private RedisStandaloneConfiguration getStandaloneConfig() {
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        config.setHostName(this.redisHealthProperties.getRedisHost());
        config.setPort(this.redisHealthProperties.getRedisPort().intValue());
        config.setPassword(RedisPassword.of((String)this.redisHealthProperties.getRedisPassword()));
        config.setDatabase(this.redisHealthProperties.getRedisDb().intValue());
        return config;
    }

    private JedisClientConfiguration.JedisClientConfigurationBuilder applyProperties(JedisClientConfiguration.JedisClientConfigurationBuilder builder) {
        Duration timeout = Duration.ofSeconds(4L);
        builder.readTimeout(timeout).connectTimeout(timeout);
        return builder;
    }

    private JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(1);
        config.setMaxIdle(1);
        config.setMinIdle(1);
        config.setMaxWait(Duration.ofSeconds(5L));
        return config;
    }
}

