/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ha.service;

import com.digiwin.dap.middle.ha.config.RedisHealthProperties;
import com.digiwin.dap.middle.ha.domain.Redis;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnectionCommands;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RedisConfigService
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(RedisConfigService.class);
    private Redis master;
    private Redis replica;
    @Autowired
    private RedisHealthProperties env;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public boolean changeHost(Redis redis) {
        JedisConnectionFactory redisFactory = (JedisConnectionFactory)this.redisTemplate.getConnectionFactory();
        if (redisFactory == null) {
            return Boolean.FALSE;
        }
        RedisStandaloneConfiguration standaloneConfig = redisFactory.getStandaloneConfiguration();
        if (standaloneConfig == null) {
            return Boolean.FALSE;
        }
        Redis run = Redis.of(redisFactory.getHostName(), redisFactory.getPort());
        try {
            if (!redis.equals(run)) {
                redisFactory.destroy();
                standaloneConfig.setHostName(redis.getHost());
                standaloneConfig.setPort(redis.getPort());
                standaloneConfig.setPassword(redis.getPassword());
                standaloneConfig.setDatabase(redis.getDatabase());
                redisFactory.afterPropertiesSet();
                this.redisTemplate.setConnectionFactory((RedisConnectionFactory)redisFactory);
                this.redisTemplate.execute(RedisConnectionCommands::ping);
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            logger.error("Redis[{}]\u5207\u6362\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f{}", (Object)redis, (Object)e.getMessage());
            redisFactory.destroy();
            standaloneConfig.setHostName(run.getHost());
            standaloneConfig.setPort(run.getPort());
            standaloneConfig.setPassword(run.getPassword());
            standaloneConfig.setDatabase(run.getDatabase());
            redisFactory.afterPropertiesSet();
            this.redisTemplate.setConnectionFactory((RedisConnectionFactory)redisFactory);
            return Boolean.FALSE;
        }
    }

    public boolean isMasterRedis() {
        try {
            JedisConnectionFactory redisFactory = (JedisConnectionFactory)this.redisTemplate.getConnectionFactory();
            Redis run = Redis.of(Objects.requireNonNull(redisFactory).getHostName(), redisFactory.getPort());
            return run.equals(this.master);
        }
        catch (Exception exception) {
            return Boolean.FALSE;
        }
    }

    public RedisStandaloneConfiguration getReplicaConfig() {
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        config.setHostName(this.replica.getHost());
        config.setPort(this.replica.getPort());
        config.setPassword(RedisPassword.of((String)this.replica.getPassword()));
        config.setDatabase(this.replica.getDatabase());
        return config;
    }

    public Redis master() {
        return this.master;
    }

    public Redis replica() {
        return this.replica;
    }

    public void afterPropertiesSet() {
        this.master = Redis.of(this.env.getRedisHost(), this.env.getRedisPort(), this.env.getRedisDb(), this.env.getRedisPassword());
        this.replica = Redis.of(this.env.getRedis2Host(), this.env.getRedis2Port(), this.env.getRedis2Db(), this.env.getRedis2Password());
    }
}

