package com.digiwin.dap.middle.ha.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RedisHealthProperties {

    /**
     * Redis Master
     */
    @Value("${spring.redis.database:0}")
    private Integer redisDb;
    @Value("${spring.redis.host:}")
    private String redisHost;
    @Value("${spring.redis.port:}")
    private Integer redisPort;
    @Value("${spring.redis.password:}")
    private String redisPassword;

    /**
     * Redis Replica
     */
    @Value("${dap.middleware.ha.redis.database:}")
    private Integer redis2Db;
    @Value("${dap.middleware.ha.redis.host:}")
    private String redis2Host;
    @Value("${dap.middleware.ha.redis.port:}")
    private Integer redis2Port;
    @JsonIgnore
    @Value("${dap.middleware.ha.redis.password:}")
    private String redis2Password;

    public Integer getRedisDb() {
        return redisDb;
    }

    public void setRedisDb(Integer redisDb) {
        this.redisDb = redisDb;
    }

    public String getRedisHost() {
        return redisHost;
    }

    public void setRedisHost(String redisHost) {
        this.redisHost = redisHost;
    }

    public Integer getRedisPort() {
        return redisPort;
    }

    public void setRedisPort(Integer redisPort) {
        this.redisPort = redisPort;
    }

    public String getRedisPassword() {
        return redisPassword;
    }

    public void setRedisPassword(String redisPassword) {
        this.redisPassword = redisPassword;
    }

    public Integer getRedis2Db() {
        return redis2Db;
    }

    public void setRedis2Db(Integer redis2Db) {
        this.redis2Db = redis2Db;
    }

    public String getRedis2Host() {
        return redis2Host;
    }

    public void setRedis2Host(String redis2Host) {
        this.redis2Host = redis2Host;
    }

    public Integer getRedis2Port() {
        return redis2Port;
    }

    public void setRedis2Port(Integer redis2Port) {
        this.redis2Port = redis2Port;
    }

    public String getRedis2Password() {
        return redis2Password;
    }

    public void setRedis2Password(String redis2Password) {
        this.redis2Password = redis2Password;
    }
}
