package com.digiwin.dap.middle.ha.domain;

import java.util.Objects;

/**
 * Redis配置信息
 *
 * @author fobgochod
 * @date 2021/1/27
 */
public class Redis {

    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 6379;
    private static final int DEFAULT_DATABASE = 0;

    private String host = DEFAULT_HOST;
    private int port = DEFAULT_PORT;
    private int database = DEFAULT_DATABASE;
    private String password;

    private Redis() {
    }

    private Redis(String host, int port) {
        this.host = host;
        this.port = port;
    }

    private Redis(String host, int port, String password) {
        this.host = host;
        this.port = port;
        this.password = password;
    }

    private Redis(String host, int port, int database, String password) {
        this.host = host;
        this.port = port;
        this.database = database;
        this.password = password;
    }

    public static Redis of() {
        return new Redis();
    }

    public static Redis of(String host, int port) {
        return new Redis(host, port);
    }

    public static Redis of(String host, int port, String password) {
        return new Redis(host, port, password);
    }

    public static Redis of(String host, int port, int database, String password) {
        return new Redis(host, port, database, password);
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getDatabase() {
        return database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Redis redis = (Redis) o;
        return port == redis.port && Objects.equals(host, redis.host);
    }

    @Override
    public int hashCode() {
        return Objects.hash(host, port);
    }

    @Override
    public String toString() {
        return "{"
                + "\"host\":\""
                + host + '\"'
                + ",\"port\":"
                + port
                + ",\"database\":"
                + database
                + ",\"password\":\""
                + password + '\"'
                + "}";
    }
}
