package com.digiwin.dap.middle.kms.constants;

import com.digiwin.dap.middle.kms.utils.PemUtils;
import com.digiwin.dap.middleware.commons.crypto.constant.AlgorithmEnum;

/**
 * @author michael
 */
public class KeyConstant {

    private static final String IV_STR_PATH = "aes_iv.pem";
    private static final String CAS_PATH = "cas_aes_key.pem";
    private static final String CONSOLE_PATH = "console_aes_key.pem";
    private static final String DIGIWIN_PATH = "digiwin_aes_key.pem";
    private static final String LOGIN_PATH = "login_aes_key.pem";
    private static final String LOGIN_AGENT_PATH = "login_agent_aes_key.pem";
    private static final String OTHER_PATH = "other_aes_key.pem";
    private static final String TEMP_TOKEN_SECRET_PATH = "temp_token_secret_aes_key.pem";
    private static final String WECHAT_UNION_ID_PATH = "wechat_union_id_aes_key.pem";
    private static final String BASE64_PRIVATE_KEY_PATH = "identity_rsa_private_key.pem";
    private static final String BASE64_PUBLIC_KEY_PATH = "identity_rsa_public_key.pem";

    public static final String IV_STR = PemUtils.readKeyFromPemFile(IV_STR_PATH, AlgorithmEnum.AES);
    public static final String CAS = PemUtils.readKeyFromPemFile(CAS_PATH, AlgorithmEnum.AES);
    public static final String CONSOLE = PemUtils.readKeyFromPemFile(CONSOLE_PATH, AlgorithmEnum.AES);
    public static final String DIGIWIN = PemUtils.readKeyFromPemFile(DIGIWIN_PATH, AlgorithmEnum.AES);
    public static final String LOGIN = PemUtils.readKeyFromPemFile(LOGIN_PATH, AlgorithmEnum.AES);
    public static final String LOGIN_AGENT = PemUtils.readKeyFromPemFile(LOGIN_AGENT_PATH, AlgorithmEnum.AES);
    public static final String OTHER = PemUtils.readKeyFromPemFile(OTHER_PATH, AlgorithmEnum.AES);
    public static final String TEMP_TOKEN_SECRET = PemUtils.readKeyFromPemFile(TEMP_TOKEN_SECRET_PATH, AlgorithmEnum.AES);
    public static final String WECHAT_UNION_ID = PemUtils.readKeyFromPemFile(WECHAT_UNION_ID_PATH, AlgorithmEnum.AES);
    public static final String BASE64_PRIVATE_KEY = PemUtils.readKeyFromPemFile(BASE64_PRIVATE_KEY_PATH, AlgorithmEnum.RSA);
    public static final String BASE64_PUBLIC_KEY = PemUtils.readKeyFromPemFile(BASE64_PUBLIC_KEY_PATH, AlgorithmEnum.RSA);

//    public static void main(String[] args) {
//        System.out.println(IV_STR.equals(com.digiwin.dap.middleware.commons.crypto.constant.KeyConstant.IV_STR));
//        System.out.println(CAS.equals(com.digiwin.dap.middleware.commons.crypto.constant.KeyConstant.CAS));
//        System.out.println(CONSOLE.equals(com.digiwin.dap.middleware.commons.crypto.constant.KeyConstant.CONSOLE));
//        System.out.println(DIGIWIN.equals(com.digiwin.dap.middleware.commons.crypto.constant.KeyConstant.DIGIWIN));
//        System.out.println(LOGIN.equals(com.digiwin.dap.middleware.commons.crypto.constant.KeyConstant.LOGIN));
//        System.out.println(LOGIN_AGENT.equals(com.digiwin.dap.middleware.commons.crypto.constant.KeyConstant.LOGIN_AGENT));
//        System.out.println(OTHER.equals(com.digiwin.dap.middleware.commons.crypto.constant.KeyConstant.OTHER));
//        System.out.println(TEMP_TOKEN_SECRET.equals(com.digiwin.dap.middleware.commons.crypto.constant.KeyConstant.TEMP_TOKEN_SECRET));
//        System.out.println(WECHAT_UNION_ID.equals(com.digiwin.dap.middleware.commons.crypto.constant.KeyConstant.WECHAT_UNION_ID));
//        System.out.println(BASE64_PRIVATE_KEY.equals(com.digiwin.dap.middleware.commons.crypto.constant.KeyConstant.BASE64_PRIVATE_KEY));
//        System.out.println(BASE64_PUBLIC_KEY.equals(com.digiwin.dap.middleware.commons.crypto.constant.KeyConstant.BASE64_PUBLIC_KEY));
//    }
}
