/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.kms.utils;

import com.digiwin.dap.middleware.commons.crypto.constant.AlgorithmEnum;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.springframework.core.io.ClassPathResource;

public class PemUtils {
    public static void writeKeyToPemFile(String key, String type, String fileName, AlgorithmEnum algorithmEnum) {
        byte[] decodedKey = key.getBytes();
        SecretKeySpec secretKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, algorithmEnum.getValue());
        try {
            ClassLoader classLoader = PemUtils.class.getClassLoader();
            Path resourcePath = Paths.get(classLoader.getResource("").toURI());
            Path filePath = Paths.get(resourcePath.toString(), fileName);
            FileWriter writer = new FileWriter(filePath.toString());
            JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
            PemObject pemObject = new PemObject(type, secretKey.getEncoded());
            pemWriter.writeObject((PemObjectGenerator)pemObject);
            pemWriter.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String readKeyFromPemFile(String filePath, AlgorithmEnum algorithmEnum) {
        try {
            ClassPathResource resource = new ClassPathResource(filePath);
            PemReader pemReader = new PemReader((Reader)new InputStreamReader(resource.getInputStream()));
            PemObject pemObject = pemReader.readPemObject();
            byte[] keyBytes = pemObject.getContent();
            return new String(new SecretKeySpec(keyBytes, algorithmEnum.getValue()).getEncoded());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read key from pem file", e);
        }
    }
}

