package com.digiwin.dap.middle.kms.utils;

import com.digiwin.dap.middleware.commons.crypto.constant.AlgorithmEnum;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.springframework.core.io.ClassPathResource;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.io.*;
import java.nio.file.Path;
import java.nio.file.Paths;

/**
 * @author michael
 */
public class PemUtils {

    public static void writeKeyToPemFile(String key, String type, String fileName, AlgorithmEnum algorithmEnum) {
        byte[] decodedKey = key.getBytes();
        SecretKey secretKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, algorithmEnum.getValue());
        try {
            // 获取resource目录的绝对路径
            ClassLoader classLoader = PemUtils.class.getClassLoader();
            Path resourcePath = Paths.get(classLoader.getResource("").toURI());
            // 构造文件路径
            Path filePath = Paths.get(resourcePath.toString(), fileName);
            // 使用FileWriter写入文件
            FileWriter writer = new FileWriter(filePath.toString());

            JcaPEMWriter pemWriter = new JcaPEMWriter(writer);
            PemObject pemObject = new PemObject(type, secretKey.getEncoded());
            pemWriter.writeObject(pemObject);
            pemWriter.flush();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String readKeyFromPemFile(String filePath, AlgorithmEnum algorithmEnum) {
        try {
            org.springframework.core.io.ClassPathResource resource = new ClassPathResource(filePath);
            PemReader pemReader = new PemReader(new InputStreamReader(resource.getInputStream()));
            PemObject pemObject = pemReader.readPemObject();
            byte[] keyBytes = pemObject.getContent();
            return new String(new SecretKeySpec(keyBytes, algorithmEnum.getValue()).getEncoded());
        } catch (Exception e) {
            throw new RuntimeException("Failed to read key from pem file", e);
        }
    }

}
