package com.digiwin.dap.middleware.language.service;

import com.digiwin.dap.middleware.language.entity.LanguageResource;
import com.digiwin.dap.middleware.service.EntityManagerService;

import java.util.List;
import java.util.Map;

public interface LanguageCrudService extends EntityManagerService<LanguageResource> {

    void save(long dataSid, String fieldName, String content);

    void save(long dataSid, String fieldName, Map<String, String> languageContents);

    void deleteByDataSid(long dataSid);

    void deleteByDataSids(List<Long> dataSids);

    /**
     * 删除后立马保存，唯一索引报错问题
     *
     * @see <a href="https://juejin.cn/post/6925749855839387656">delete-then-save唯一索引冲突问题</a>
     * @see <a href="https://github.com/spring-projects/spring-data-jpa/issues/1100">Delete event not flushed before Save in JpaRepository</a>
     */
    void deleteByDataSidsInBatch(List<Long> dataSids);

    List<LanguageResource> findByDataSid(long dataSid);

    List<LanguageResource> findByDataSids(List<Long> dataSids);

    String findContent(long dataSid, String fieldName);

    String findContent(long dataSid, String fieldName, String language);

    Map<Long, String> findContent(List<Long> dataSids, String fieldName);

    Map<Long, String> findContent(List<Long> dataSids, String fieldName, String language);
}
