/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.language.service.impl;

import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.language.entity.LanguageDefault;
import com.digiwin.dap.middleware.language.entity.LanguageResource;
import com.digiwin.dap.middleware.language.mapper.LanguageMapper;
import com.digiwin.dap.middleware.language.repository.LanguageDefaultRepository;
import com.digiwin.dap.middleware.language.service.LanguageService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

@Service
public class LanguageServiceImpl
implements LanguageService {
    private static final Logger logger = LoggerFactory.getLogger(LanguageServiceImpl.class);
    private static final String PRIMARY_FIELD_NAME = "sid";
    private static final String ID_FIELD_NAME = "id";
    private static List<LanguageDefault> languageDefaultList;
    @Autowired
    private LanguageDefaultRepository languageDefaultRepository;
    @Autowired
    private LanguageMapper languageMapper;

    private static List<Field> getFields(Collection<String> filedNames, Class<?> valueType) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (String fieldName : filedNames) {
            Field field = ReflectionUtils.findField(valueType, (String)fieldName);
            if (field == null) continue;
            fields.add(field);
        }
        return fields;
    }

    private static <T> String getIdValue(T target, Class<T> targetType) {
        return LanguageServiceImpl.getIdValue(target, ID_FIELD_NAME, targetType);
    }

    private static <T> String getIdValue(T target, String idName, Class<T> targetType) {
        if (StrUtils.isEmpty((String)idName)) {
            return null;
        }
        Field idField = ReflectionUtils.findField(targetType, (String)idName);
        if (idField == null) {
            logger.error("\u6307\u5b9a\u7684id\u5b57\u6bb5[{}]\u4e0d\u5b58\u5728 target={}", (Object)idName, target);
            return null;
        }
        ReflectionUtils.makeAccessible((Field)idField);
        return (String)ReflectionUtils.getField((Field)idField, target);
    }

    private static <T> Long getSid(T target, Class<T> targetType) {
        return LanguageServiceImpl.getSid(target, PRIMARY_FIELD_NAME, targetType);
    }

    private static <T> Long getSid(T target, String primaryName, Class<T> targetType) {
        Field primaryField = ReflectionUtils.findField(targetType, (String)primaryName);
        if (primaryField == null) {
            throw new RuntimeException(String.format("\u6307\u5b9a\u7684\u4e3b\u952e\u5b57\u6bb5[%s]\u4e0d\u5b58\u5728", primaryName));
        }
        ReflectionUtils.makeAccessible((Field)primaryField);
        Long sid = (Long)ReflectionUtils.getField((Field)primaryField, target);
        return Optional.ofNullable(sid).orElse(0L);
    }

    @PostConstruct
    public void init() {
        languageDefaultList = this.languageDefaultRepository.findAll();
    }

    @Override
    public <T> T parse(T target, Class<T> targetType) {
        return this.parse(target, LanguageServiceImpl.getSid(target, targetType), targetType);
    }

    @Override
    public <T, K> T parse(T target, Class<T> targetType, Class<K> entityType) {
        return this.parse(target, (long)LanguageServiceImpl.getSid(target, targetType), targetType, entityType);
    }

    @Override
    public <T> T parse(T target, long dataSid, Class<T> targetType) {
        return this.parse(target, dataSid, new HashMap<String, String>(), LocaleContextHolder.getLocale().toLanguageTag(), targetType);
    }

    @Override
    public <T, K> T parse(T target, long dataSid, Class<T> targetType, Class<K> entityType) {
        return this.parse(target, dataSid, LanguageServiceImpl.getIdValue(target, targetType), new HashMap<String, String>(), LocaleContextHolder.getLocale().toLanguageTag(), targetType, entityType);
    }

    @Override
    public <T> T parse(T target, String primaryName, Class<T> targetType) {
        return this.parse(target, primaryName, new HashMap<String, String>(), LocaleContextHolder.getLocale().toLanguageTag(), targetType);
    }

    @Override
    public <T, K> T parse(T target, String primaryName, Class<T> targetType, Class<K> entityType) {
        return this.parse(target, primaryName, ID_FIELD_NAME, new HashMap<String, String>(), LocaleContextHolder.getLocale().toLanguageTag(), targetType, entityType);
    }

    @Override
    public <T> T parse(T target, long dataSid, String languageTag, Class<T> targetType) {
        return this.parse(target, dataSid, new HashMap<String, String>(), languageTag, targetType);
    }

    @Override
    public <T, K> T parse(T target, long dataSid, String languageTag, Class<T> targetType, Class<K> entityType) {
        return this.parse(target, dataSid, LanguageServiceImpl.getIdValue(target, targetType), new HashMap<String, String>(), languageTag, targetType, entityType);
    }

    @Override
    public <T> T parse(T target, String primaryName, String languageTag, Class<T> targetType) {
        return this.parse(target, primaryName, new HashMap<String, String>(), languageTag, targetType);
    }

    @Override
    public <T, K> T parse(T target, String primaryName, String languageTag, Class<T> targetType, Class<K> entityType) {
        return this.parse(target, primaryName, ID_FIELD_NAME, new HashMap<String, String>(), languageTag, targetType, entityType);
    }

    @Override
    public <T> T parse(T target, String primaryName, Map<String, String> fieldMap, Class<T> targetType) {
        return this.parse(target, primaryName, fieldMap, LocaleContextHolder.getLocale().toLanguageTag(), targetType);
    }

    @Override
    public <T, K> T parse(T target, String primaryName, Map<String, String> fieldMap, Class<T> targetType, Class<K> entityType) {
        return this.parse(target, primaryName, ID_FIELD_NAME, fieldMap, LocaleContextHolder.getLocale().toLanguageTag(), targetType, entityType);
    }

    @Override
    public <T> T parse(T target, long dataSid, Map<String, String> fieldMap, Class<T> targetType) {
        return this.parse(target, dataSid, fieldMap, LocaleContextHolder.getLocale().toLanguageTag(), targetType);
    }

    @Override
    public <T, K> T parse(T target, long dataSid, Map<String, String> fieldMap, Class<T> targetType, Class<K> entityType) {
        return this.parse(target, dataSid, LanguageServiceImpl.getIdValue(target, ID_FIELD_NAME, targetType), fieldMap, LocaleContextHolder.getLocale().toLanguageTag(), targetType, entityType);
    }

    @Override
    public <T> T parse(T target, long dataSid, Map<String, String> fieldMap, String languageTag, Class<T> targetType) {
        return this.parse(target, dataSid, null, fieldMap, languageTag, targetType, null);
    }

    @Override
    public <T> T parse(T target, String primaryName, Map<String, String> fieldMap, String languageTag, Class<T> targetType) {
        return this.parse(target, primaryName, null, fieldMap, languageTag, targetType, null);
    }

    @Override
    public <T, K> T parse(T target, String primaryName, String idName, Map<String, String> fieldMap, String languageTag, Class<T> targetType, Class<K> entityType) {
        return this.parse(target, LanguageServiceImpl.getSid(target, primaryName, targetType), LanguageServiceImpl.getIdValue(target, idName, targetType), fieldMap, languageTag, targetType, entityType);
    }

    @Override
    public <T, K> T parse(T target, long dataSid, String idValue, Map<String, String> fieldMap, String languageTag, Class<T> targetType, Class<K> entityType) {
        List<LanguageResource> languages = this.languageMapper.findByDataSidAndLanguage(dataSid, languageTag);
        if (fieldMap.isEmpty()) {
            languages.stream().map(LanguageResource::getFieldName).distinct().forEach(p -> fieldMap.put((String)p, (String)p));
        }
        Map<String, String> valueMap = languages.stream().collect(Collectors.toMap(LanguageResource::getFieldName, LanguageResource::getContent, (a, b) -> b));
        Map<String, String> baseValueMap = this.getBaseValueMap(fieldMap, languageTag, entityType);
        List<Field> fields = LanguageServiceImpl.getFields(fieldMap.keySet(), targetType);
        for (Field field : fields) {
            try {
                ReflectionUtils.makeAccessible((Field)field);
                String value = valueMap.get(fieldMap.get(field.getName()));
                if (StrUtils.isNotEmpty((String)value)) {
                    field.set(target, value);
                    continue;
                }
                if (entityType == null || idValue == null || !StrUtils.isNotEmpty((String)(value = baseValueMap.get(entityType.getSimpleName() + "." + idValue + "-" + fieldMap.get(field.getName()))))) continue;
                field.set(target, value);
            }
            catch (Exception e) {
                logger.error("\u591a\u8bed\u8a00\u5b57\u6bb5\uff1a[{}->{}]\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{field.getName(), fieldMap.get(field.getName()), e.getMessage()});
            }
        }
        return target;
    }

    @Override
    public <T> List<T> parse(List<T> targets, Class<T> targetType) {
        return this.parse(targets, PRIMARY_FIELD_NAME, targetType);
    }

    @Override
    public <T, K> List<T> parse(List<T> targets, Class<T> targetType, Class<K> entityType) {
        return this.parse(targets, PRIMARY_FIELD_NAME, (Map<String, String>)new HashMap<String, String>(), targetType, entityType);
    }

    @Override
    public <T> List<T> parse(List<T> targets, Map<String, String> fieldMap, Class<T> targetType) {
        return this.parse(targets, PRIMARY_FIELD_NAME, fieldMap, LocaleContextHolder.getLocale().toLanguageTag(), targetType);
    }

    @Override
    public <T, K> List<T> parse(List<T> targets, Map<String, String> fieldMap, Class<T> targetType, Class<K> entityType) {
        return this.parse(targets, PRIMARY_FIELD_NAME, ID_FIELD_NAME, fieldMap, LocaleContextHolder.getLocale().toLanguageTag(), targetType, entityType);
    }

    @Override
    public <T> List<T> parse(List<T> targets, String primaryName, Class<T> targetType) {
        return this.parse(targets, primaryName, LocaleContextHolder.getLocale().toLanguageTag(), targetType);
    }

    @Override
    public <T, K> List<T> parse(List<T> targets, String primaryName, Class<T> targetType, Class<K> entityType) {
        return this.parse(targets, primaryName, LocaleContextHolder.getLocale().toLanguageTag(), targetType, entityType);
    }

    @Override
    public <T> List<T> parse(List<T> targets, Locale locale, Class<T> targetType) {
        return this.parse(targets, PRIMARY_FIELD_NAME, (Map<String, String>)new HashMap<String, String>(), locale.toLanguageTag(), targetType);
    }

    @Override
    public <T, K> List<T> parse(List<T> targets, Locale locale, Class<T> targetType, Class<K> entityType) {
        return this.parse(targets, PRIMARY_FIELD_NAME, ID_FIELD_NAME, (Map<String, String>)new HashMap<String, String>(), locale.toLanguageTag(), targetType, entityType);
    }

    @Override
    public <T> List<T> parse(List<T> targets, String primaryName, Map<String, String> fieldMap, Class<T> targetType) {
        return this.parse(targets, primaryName, fieldMap, LocaleContextHolder.getLocale().toLanguageTag(), targetType);
    }

    @Override
    public <T, K> List<T> parse(List<T> targets, String primaryName, Map<String, String> fieldMap, Class<T> targetType, Class<K> entityType) {
        return this.parse(targets, primaryName, ID_FIELD_NAME, fieldMap, LocaleContextHolder.getLocale().toLanguageTag(), targetType, entityType);
    }

    @Override
    public <T> List<T> parse(List<T> targets, String primaryName, String languageTag, Class<T> targetType) {
        return this.parse(targets, primaryName, (Map<String, String>)new HashMap<String, String>(), languageTag, targetType);
    }

    @Override
    public <T, K> List<T> parse(List<T> targets, String primaryName, String languageTag, Class<T> targetType, Class<K> entityType) {
        return this.parse(targets, primaryName, ID_FIELD_NAME, (Map<String, String>)new HashMap<String, String>(), languageTag, targetType, entityType);
    }

    @Override
    public <T> List<T> parse(List<T> targets, List<Long> dataSids, Map<String, String> fieldMap, Class<T> targetType) {
        return this.parse(targets, dataSids, fieldMap, LocaleContextHolder.getLocale().toLanguageTag(), targetType);
    }

    @Override
    public <T> List<T> parse(List<T> targets, List<Long> dataSids, Map<String, String> fieldMap, String languageTag, Class<T> targetType) {
        return this.parse(targets, PRIMARY_FIELD_NAME, dataSids, fieldMap, languageTag, targetType);
    }

    @Override
    public <T> List<T> parse(List<T> targets, Map<String, String> fieldMap, String languageTag, Class<T> targetType) {
        return this.parse(targets, PRIMARY_FIELD_NAME, null, new ArrayList<Long>(), fieldMap, languageTag, targetType, null);
    }

    @Override
    public <T, K> List<T> parse(List<T> targets, Map<String, String> fieldMap, String languageTag, Class<T> targetType, Class<K> entityType) {
        return this.parse(targets, PRIMARY_FIELD_NAME, ID_FIELD_NAME, new ArrayList<Long>(), fieldMap, languageTag, targetType, entityType);
    }

    @Override
    public <T> List<T> parse(List<T> targets, String primaryName, Map<String, String> fieldMap, String languageTag, Class<T> targetType) {
        return this.parse(targets, primaryName, null, new ArrayList<Long>(), fieldMap, languageTag, targetType, null);
    }

    @Override
    public <T> List<T> parse(List<T> targets, String primaryName, List<Long> dataSids, Map<String, String> fieldMap, String languageTag, Class<T> targetType) {
        return this.parse(targets, primaryName, null, dataSids, fieldMap, languageTag, targetType, null);
    }

    @Override
    public <T> List<T> parse(List<T> targets, Field primaryField, List<Long> dataSids, Map<String, String> fieldMap, String languageTag, Class<T> targetType) {
        return this.parse(targets, primaryField, null, dataSids, fieldMap, languageTag, targetType, null);
    }

    @Override
    public <T, K> List<T> parse(List<T> targets, String primaryName, String idName, Map<String, String> fieldMap, String languageTag, Class<T> targetType, Class<K> entityType) {
        return this.parse(targets, this.getPrimaryField(targets, primaryName, targetType), this.getIdField(targets, idName, targetType), new ArrayList<Long>(), fieldMap, languageTag, targetType, entityType);
    }

    @Override
    public <T, K> List<T> parse(List<T> targets, String primaryName, String idName, List<Long> dataSids, Map<String, String> fieldMap, String languageTag, Class<T> targetType, Class<K> entityType) {
        return this.parse(targets, this.getPrimaryField(targets, primaryName, targetType), this.getIdField(targets, idName, targetType), dataSids, fieldMap, languageTag, targetType, entityType);
    }

    @Override
    public <T, K> List<T> parse(List<T> targets, Field primaryField, Field idField, List<Long> dataSids, Map<String, String> fieldMap, String languageTag, Class<T> targetType, Class<K> entityType) {
        if (CollectionUtils.isEmpty(targets) || primaryField == null) {
            return targets;
        }
        ReflectionUtils.makeAccessible((Field)primaryField);
        if (CollectionUtils.isEmpty(dataSids)) {
            dataSids = targets.stream().flatMap(x -> Stream.of((Long)ReflectionUtils.getField((Field)primaryField, (Object)x))).collect(Collectors.toList());
        }
        List<LanguageResource> languages = this.languageMapper.findByDataSidsAndLanguage(dataSids, languageTag);
        if (fieldMap.isEmpty()) {
            languages.stream().map(LanguageResource::getFieldName).distinct().forEach(p -> fieldMap.put((String)p, (String)p));
        }
        Map<String, String> valueMap = languages.stream().filter(a -> a.getContent() != null).collect(Collectors.toMap(p -> p.getDataSid() + "-" + p.getFieldName(), LanguageResource::getContent, (a, b) -> b));
        Map<String, String> baseValueMap = this.getBaseValueMap(fieldMap, languageTag, entityType);
        List<Field> fields = LanguageServiceImpl.getFields(fieldMap.keySet(), targetType);
        Optional.ofNullable(idField).ifPresent(ReflectionUtils::makeAccessible);
        for (T target : targets) {
            Object primaryValue = ReflectionUtils.getField((Field)primaryField, target);
            Object idValue = idField == null ? null : ReflectionUtils.getField((Field)idField, target);
            for (Field field : fields) {
                try {
                    ReflectionUtils.makeAccessible((Field)field);
                    String value = valueMap.get(primaryValue + "-" + fieldMap.get(field.getName()));
                    if (StrUtils.isNotEmpty((String)value)) {
                        field.set(target, value);
                        continue;
                    }
                    if (entityType == null || idValue == null || !StrUtils.isNotEmpty((String)(value = baseValueMap.get(entityType.getSimpleName() + "." + idValue + "-" + fieldMap.get(field.getName()))))) continue;
                    field.set(target, value);
                }
                catch (Exception e) {
                    logger.error("\u4e3b\u952e\u4fe1\u606f\uff1a[{}]({})\uff0c\u591a\u8bed\u8a00\u5b57\u6bb5\uff1a[{}->{}]\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{primaryField.getName(), primaryValue, field.getName(), fieldMap.get(field.getName()), e.getMessage()});
                }
            }
        }
        return targets;
    }

    private <K> Map<String, String> getBaseValueMap(Map<String, String> fieldMap, String languageTag, Class<K> entityType) {
        if (entityType == null) {
            return Collections.emptyMap();
        }
        List baseList = languageDefaultList.stream().filter(x -> Objects.equals(languageTag, x.getLanguage()) && x.getDataId().startsWith(entityType.getSimpleName() + ".")).collect(Collectors.toList());
        baseList.stream().map(LanguageDefault::getFieldName).distinct().forEach(baseField -> {
            if (!fieldMap.containsValue(baseField)) {
                fieldMap.put((String)baseField, (String)baseField);
            }
        });
        return baseList.stream().collect(Collectors.toMap(o -> o.getDataId() + "-" + o.getFieldName(), LanguageDefault::getContent, (a, b) -> b));
    }

    private <T> Field getPrimaryField(List<T> targets, Class<T> targetType) {
        Field primaryField = ReflectionUtils.findField(targetType, (String)PRIMARY_FIELD_NAME);
        if (primaryField == null) {
            logger.error("\u6307\u5b9a\u7684\u4e3b\u952e\u5b57\u6bb5[{}]\u4e0d\u5b58\u5728 target={}", (Object)PRIMARY_FIELD_NAME, CollectionUtils.isEmpty(targets) ? null : targets.get(0));
        }
        return primaryField;
    }

    private <T> Field getPrimaryField(List<T> targets, String primaryName, Class<T> targetType) {
        Field primaryField = ReflectionUtils.findField(targetType, (String)primaryName);
        if (primaryField == null) {
            logger.error("\u6307\u5b9a\u7684\u4e3b\u952e\u5b57\u6bb5[{}]\u4e0d\u5b58\u5728 target={}", (Object)primaryName, CollectionUtils.isEmpty(targets) ? null : targets.get(0));
        }
        return primaryField;
    }

    private <T> Field getIdField(List<T> targets, Class<T> targetType) {
        Field idField = ReflectionUtils.findField(targetType, (String)ID_FIELD_NAME);
        if (idField == null) {
            logger.error("\u6307\u5b9a\u7684id\u5b57\u6bb5[{}]\u4e0d\u5b58\u5728 target={}, ", (Object)ID_FIELD_NAME, CollectionUtils.isEmpty(targets) ? null : targets.get(0));
        }
        return idField;
    }

    private <T> Field getIdField(List<T> targets, String idName, Class<T> targetType) {
        if (StrUtils.isEmpty((String)idName)) {
            return null;
        }
        Field idField = ReflectionUtils.findField(targetType, (String)idName);
        if (idField == null) {
            logger.error("\u6307\u5b9a\u7684id\u5b57\u6bb5[{}]\u4e0d\u5b58\u5728 target={}, ", (Object)idName, CollectionUtils.isEmpty(targets) ? null : targets.get(0));
        }
        return idField;
    }
}

