package com.digiwin.dap.middleware.language.entity;

import com.digiwin.dap.middleware.entity.BaseEntity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 多语言资源表
 *
 * @author fobgochod
 */
@Entity
@Table(name = "multi_language_resource")
public class LanguageResource extends BaseEntity {
    /** 数据sid */
    @Column(name = "data_sid")
    private long dataSid;
    /** 字段名 */
    @Column(name = "field_name")
    private String fieldName;
    /** 内容 */
    private String content;
    /** 多语言：zh-CN;zh-TW;en-US 等 */
    private String language;

    public LanguageResource() {
    }

    public LanguageResource(long dataSid, String fieldName, String content, String language) {
        this.dataSid = dataSid;
        this.fieldName = fieldName;
        this.content = content;
        this.language = language;
    }

    public long getDataSid() {
        return dataSid;
    }

    public void setDataSid(long dataSid) {
        this.dataSid = dataSid;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}
