-- 多语言表
CREATE TABLE "multi_language_resource"
(
    "sid"             bigint      NOT NULL,
    "content"         text COMMENT '内容',
    "data_sid"        bigint      NOT NULL COMMENT '组织形态sid,应用、模组、条件、行为sid',
    "field_name"      varchar(40) NOT NULL COMMENT '字段名称',
    "language"        varchar(40) NOT NULL COMMENT '语言别',
    "create_by"       bigint       DEFAULT '0',
    "create_by_id"    varchar(255) DEFAULT NULL,
    "create_date"     datetime     DEFAULT NULL,
    "create_org"      bigint       DEFAULT '0',
    "create_provider" bigint       DEFAULT '0',
    "deleted"         bit(1)       DEFAULT b'0',
    "disabled"        bit(1)       DEFAULT b'0',
    "hash"            varchar(40)  DEFAULT NULL,
    "modify_by"       bigint       DEFAULT '0',
    "modify_by_id"    varchar(255) DEFAULT NULL,
    "modify_date"     datetime     DEFAULT NULL,
    "modify_provider" bigint       DEFAULT '0',
    PRIMARY KEY ("sid") USING BTREE,
    UNIQUE KEY "uk_datasid_fieldname_language" ("data_sid", "field_name", "language") USING BTREE,
    KEY "idx_fieldname" ("field_name") USING BTREE,
    KEY "idx_language" ("language")
);

CREATE TABLE "multi_language_default"
(
    "sid"             bigint      NOT NULL,
    "field_name"      varchar(40) NOT NULL COMMENT '字段名称',
    "language"        varchar(40) NOT NULL COMMENT '语言别',
    "data_id"         varchar(100) NOT NULL COMMENT '数据id',
    "content"         text COMMENT '内容',
    "create_by"       bigint       DEFAULT '0',
    "create_by_id"    varchar(255) DEFAULT NULL,
    "create_date"     datetime     DEFAULT NULL,
    "create_org"      bigint       DEFAULT '0',
    "create_provider" bigint       DEFAULT '0',
    "deleted"         bit(1)       DEFAULT b'0',
    "disabled"        bit(1)       DEFAULT b'0',
    "hash"            varchar(40)  DEFAULT NULL,
    "modify_by"       bigint       DEFAULT '0',
    "modify_by_id"    varchar(255) DEFAULT NULL,
    "modify_date"     datetime     DEFAULT NULL,
    "modify_provider" bigint       DEFAULT '0',
    PRIMARY KEY ("sid"),
    UNIQUE KEY "uk_fieldname_dataid_language" ("field_name", "data_id", "language") USING BTREE
) COMMENT ='默认多语言数据';
