package com.digiwin.dap.middleware.language.service.impl;

import com.digiwin.dap.middleware.language.entity.LanguageResource;
import com.digiwin.dap.middleware.language.repository.LanguageRepository;
import com.digiwin.dap.middleware.language.service.LanguageCrudService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class LanguageCrudServiceImpl extends BaseEntityManagerService<LanguageResource> implements LanguageCrudService {

    @Autowired
    private LanguageRepository languageRepository;

    @Override
    protected LanguageRepository getRepository() {
        return languageRepository;
    }

    @Override
    public void save(long dataSid, String fieldName, String content) {
        LanguageResource languageResource = languageRepository.findByDataSidAndFieldNameAndLanguage(dataSid, fieldName, LocaleContextHolder.getLocale().toLanguageTag());
        if (languageResource != null) {
            languageResource.setContent(content);
            this.update(languageResource);
        } else {
            languageResource = new LanguageResource();
            languageResource.setDataSid(dataSid);
            languageResource.setFieldName(fieldName);
            languageResource.setContent(content);
            languageResource.setLanguage(LocaleContextHolder.getLocale().toLanguageTag());
            this.create(languageResource);
        }
    }

    @Override
    public void save(long dataSid, String fieldName, Map<String, String> languageContents) {
        List<LanguageResource> languageResources = new ArrayList<>();
        for (Map.Entry<String, String> entry : languageContents.entrySet()) {
            LanguageResource languageResource = languageRepository.findByDataSidAndFieldNameAndLanguage(dataSid, fieldName, entry.getKey());
            if (languageResource != null) {
                languageResource.setContent(entry.getValue());
            } else {
                languageResource = new LanguageResource();
                languageResource.setDataSid(dataSid);
                languageResource.setFieldName(fieldName);
                languageResource.setContent(entry.getValue());
                languageResource.setLanguage(entry.getKey());
            }
            languageResources.add(languageResource);
        }
        this.saveAll(languageResources);
    }

    @Override
    public void deleteByDataSid(long dataSid) {
        languageRepository.deleteByDataSid(dataSid);
    }

    @Override
    public void deleteByDataSids(List<Long> dataSids) {
        languageRepository.deleteByDataSidIn(dataSids);
    }

    @Override
    public void deleteByDataSidsInBatch(List<Long> dataSids) {
        List<LanguageResource> resources = this.findByDataSids(dataSids);
        languageRepository.deleteAllInBatch(resources);
    }

    @Override
    public List<LanguageResource> findByDataSid(long dataSid) {
        return languageRepository.findByDataSid(dataSid);
    }

    @Override
    public List<LanguageResource> findByDataSids(List<Long> dataSids) {
        return languageRepository.findByDataSidIn(dataSids);
    }

    @Override
    public String findContent(long dataSid, String fieldName) {
        return findContent(dataSid, fieldName, LocaleContextHolder.getLocale().toLanguageTag());
    }

    @Override
    public String findContent(long dataSid, String fieldName, String language) {
        LanguageResource languageResource = languageRepository.findByDataSidAndFieldNameAndLanguage(dataSid, fieldName, language);
        if (languageResource != null) {
            return languageResource.getContent();
        }
        return null;
    }

    @Override
    public Map<Long, String> findContent(List<Long> dataSids, String fieldName) {
        return findContent(dataSids, fieldName, LocaleContextHolder.getLocale().toLanguageTag());
    }

    @Override
    public Map<Long, String> findContent(List<Long> dataSids, String fieldName, String language) {
        List<LanguageResource> languageResources = languageRepository.findByDataSidInAndFieldNameAndLanguage(dataSids, fieldName, language);
        // 防止LanguageResource::getContent NPE
        languageResources.stream().filter(l -> l.getContent() == null).forEach(l -> l.setContent(""));
        return languageResources.stream().collect(Collectors.toMap(LanguageResource::getDataSid, LanguageResource::getContent));
    }
}
