package com.digiwin.dap.middle.license.bean;

import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.util.JsonUtils;

import java.io.IOException;
import java.util.StringJoiner;

public class DeviceInfo {

    private String ip;
    private String machineId;
    private String systemUUID;
    private String bootID;
    private String nodeName;
    private String osImage;
    private String osName;
    private String osVersion;
    private String osArch;

    public static DeviceInfo of(String machineCode) {
        byte[] bytes = Base64.decode(machineCode);
        try {
            return JsonUtils.createObjectMapper().readValue(bytes, DeviceInfo.class);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getMachineId() {
        return machineId;
    }

    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    public String getSystemUUID() {
        return systemUUID;
    }

    public void setSystemUUID(String systemUUID) {
        this.systemUUID = systemUUID;
    }

    public String getBootID() {
        return bootID;
    }

    public void setBootID(String bootID) {
        this.bootID = bootID;
    }

    public String getNodeName() {
        return nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getOsImage() {
        return osImage;
    }

    public void setOsImage(String osImage) {
        this.osImage = osImage;
    }

    public String getOsName() {
        return osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getOsVersion() {
        return osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getOsArch() {
        return osArch;
    }

    public void setOsArch(String osArch) {
        this.osArch = osArch;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", DeviceInfo.class.getSimpleName() + "[", "]")
                .add("ip='" + ip + "'")
                .add("machineId='" + machineId + "'")
                .add("systemUUID='" + systemUUID + "'")
                .add("bootID='" + bootID + "'")
                .add("nodeName='" + nodeName + "'")
                .add("osImage='" + osImage + "'")
                .add("osName='" + osName + "'")
                .add("osVersion='" + osVersion + "'")
                .add("osArch='" + osArch + "'")
                .toString();
    }
}
