package com.digiwin.dap.middle.license.bean;

/**
 * 临时使用，和标准返回结果保持一致
 */
public class StdData<T> {

    private int code;
    private String message;
    private T data;
    private boolean success;

    public StdData() {
    }

    public StdData(int code, String message, boolean success) {
        this.code = code;
        this.message = message;
        this.success = success;
    }

    public static <T> StdData<T> ofSuccess(T data) {
        StdData<T> stdData = new StdData<>(200, "success", true);
        stdData.setData(data);
        return stdData;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Override
    public String toString() {
        return "StdData{" +
                "code=" + code +
                ", message='" + message + '\'' +
                ", data=" + data +
                ", success=" + success +
                '}';
    }
}
