package com.digiwin.dap.middle.license.processor;

import com.digiwin.dap.middle.license.bean.DeviceInfo;
import com.digiwin.dap.middle.license.bean.ShellInfo;
import com.digiwin.dap.middle.license.utils.SshUtils;
import com.jcraft.jsch.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * 连接SSH
 * 执行命令Linux命令
 *
 * @author fobgochod
 */
public class SshProcessor implements DeviceInfoProcessor {

    private static final Logger logger = LoggerFactory.getLogger(SshProcessor.class);

    public static DeviceInfo getDeviceInfo() {
        return getDeviceInfo("172.16.2.214", 22, "root", "pAssW0rD-172.16.2.214", null);
    }

    public static DeviceInfo getDeviceInfo(String host, int port, String username, String password, String identity) {
        logger.info("{}:{}/{}", host, port, username);
        ShellInfo shellInfo = new ShellInfo(host, port, username);
        shellInfo.setPassword(password);
        shellInfo.setIdentity(identity);
        Session session = SshUtils.getSession(shellInfo);
        return getDeviceInfo(session);
    }

    private static DeviceInfo getDeviceInfo(Session session) {
        SshUtils.connect(session);
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setMachineId(SshUtils.execOne(session, "cat /etc/machine-id"));
        deviceInfo.setSystemUUID(SshUtils.execOne(session, "cat /sys/class/dmi/id/product_uuid"));
        deviceInfo.setBootID(SshUtils.execOne(session, "cat /proc/sys/kernel/random/boot_id"));
        deviceInfo.setNodeName(SshUtils.execOne(session, "hostname"));
        deviceInfo.setOsImage(SshUtils.execOne(session, "cat /etc/system-release"));
        deviceInfo.setOsName(SshUtils.execOne(session, "uname -s"));
        deviceInfo.setOsVersion(SshUtils.execOne(session, "uname -r"));
        deviceInfo.setOsArch(SshUtils.execOne(session, "uname -i"));
        SshUtils.close(session);
        return deviceInfo;
    }

}