/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.license.processor;

import com.digiwin.dap.middle.license.bean.DeviceInfo;
import com.digiwin.dap.middle.license.bean.PodInfo;
import com.digiwin.dap.middle.license.processor.DeviceInfoProcessor;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1NodeAddress;
import io.kubernetes.client.openapi.models.V1NodeStatus;
import io.kubernetes.client.openapi.models.V1NodeSystemInfo;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodSpec;
import io.kubernetes.client.util.ClientBuilder;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.KubeConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sProcessor
implements DeviceInfoProcessor {
    private static final Logger logger = LoggerFactory.getLogger(K8sProcessor.class);
    private static final String InternalIP = "InternalIP";
    private static final String CONFIG_PATH = "/206_config";
    private static ApiClient client;

    public static List<PodInfo> getPodInfo() {
        try {
            CoreV1Api api = new CoreV1Api();
            CoreV1Api.APIlistPodForAllNamespacesRequest podList = api.listPodForAllNamespaces();
            ArrayList<PodInfo> podInfos = new ArrayList<PodInfo>();
            for (V1Pod pod : podList.execute().getItems()) {
                V1ObjectMeta metadata = pod.getMetadata();
                V1PodSpec spec = pod.getSpec();
                if (metadata == null || spec == null) continue;
                PodInfo podInfo = new PodInfo();
                podInfo.setName(metadata.getName());
                podInfo.setNamespace(metadata.getNamespace());
                podInfo.setNodeName(spec.getNodeName());
                podInfos.add(podInfo);
            }
            return podInfos;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static List<DeviceInfo> getNodeInfo(String namespace) {
        List nodeNames = K8sProcessor.getPodInfo().stream().filter(p -> p.getNamespace().contains(namespace)).map(PodInfo::getNodeName).collect(Collectors.toList());
        return K8sProcessor.getNodeInfo().stream().filter(p -> nodeNames.contains(p.getNodeName())).collect(Collectors.toList());
    }

    public static List<DeviceInfo> getNodeInfo() {
        try {
            CoreV1Api api = new CoreV1Api();
            CoreV1Api.APIlistNodeRequest nodeList = api.listNode();
            ArrayList<DeviceInfo> deviceInfos = new ArrayList<DeviceInfo>();
            for (V1Node node : nodeList.execute().getItems()) {
                V1NodeStatus status = node.getStatus();
                if (status == null) continue;
                DeviceInfo deviceInfo = new DeviceInfo();
                deviceInfo.setNodeName(node.getMetadata().getName());
                V1NodeSystemInfo nodeInfo = status.getNodeInfo();
                if (nodeInfo != null) {
                    deviceInfo.setMachineId(nodeInfo.getMachineID());
                    deviceInfo.setSystemUUID(nodeInfo.getSystemUUID());
                    deviceInfo.setBootID(nodeInfo.getBootID());
                    deviceInfo.setOsName(nodeInfo.getOperatingSystem());
                    deviceInfo.setOsImage(nodeInfo.getOsImage());
                    deviceInfo.setOsVersion(nodeInfo.getKernelVersion());
                    deviceInfo.setOsArch(nodeInfo.getArchitecture());
                }
                if (status.getAddresses() != null) {
                    for (V1NodeAddress address : status.getAddresses()) {
                        if (!InternalIP.equals(address.getType())) continue;
                        deviceInfo.setIp(address.getAddress());
                        break;
                    }
                }
                deviceInfos.add(deviceInfo);
            }
            return deviceInfos;
        }
        catch (ApiException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    static {
        try {
            client = Config.fromCluster();
        }
        catch (Exception e) {
            try {
                InputStream inputStream = K8sProcessor.class.getResourceAsStream(CONFIG_PATH);
                client = ClientBuilder.kubeconfig((KubeConfig)KubeConfig.loadKubeConfig((Reader)new InputStreamReader(inputStream))).build();
            }
            catch (IOException ex) {
                logger.error(e.getMessage(), (Throwable)ex);
                throw new RuntimeException(e);
            }
        }
        Configuration.setDefaultApiClient((ApiClient)client);
    }
}

