/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.license.utils;

import com.digiwin.dap.middle.license.bean.ShellInfo;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshUtils {
    private static final Logger logger = LoggerFactory.getLogger(SshUtils.class);

    public static Session getSession(ShellInfo shellInfo) {
        try {
            JSch jSch = new JSch();
            Session session = jSch.getSession(shellInfo.getUsername(), shellInfo.getHost(), shellInfo.getPort());
            if (StrUtils.isNotEmpty((String)shellInfo.getIdentity())) {
                if (SshUtils.isPrivateKeyFile(shellInfo.getIdentity())) {
                    jSch.addIdentity(shellInfo.getIdentity(), shellInfo.getPassphrase());
                } else if (SshUtils.isPrivateKeyString(shellInfo.getIdentity())) {
                    jSch.addIdentity("id_rsa", shellInfo.getIdentity().getBytes(), null, null);
                }
            } else if (StrUtils.isNotEmpty((String)shellInfo.getPassword())) {
                session.setPassword(shellInfo.getPassword());
            }
            session.setConfig("StrictHostKeyChecking", "no");
            return session;
        }
        catch (Exception e) {
            logger.error("JSch create session error:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String execOne(Session session, String command) {
        List<String> results = SshUtils.exec(session, command);
        return results.isEmpty() ? null : results.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> exec(Session session, String command) {
        logger.debug(">> {}", (Object)command);
        ArrayList<String> resultLines = new ArrayList<String>();
        ChannelExec channel = null;
        try {
            channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand(command);
            channel.setPty(true);
            InputStream is = channel.getInputStream();
            channel.connect(0);
            try {
                String inputLine;
                BufferedReader inputReader = new BufferedReader(new InputStreamReader(is));
                while ((inputLine = inputReader.readLine()) != null) {
                    resultLines.add(inputLine);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        logger.error("JSch inputStream close error:", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("IOException:", (Throwable)e);
        }
        finally {
            if (channel != null) {
                try {
                    channel.disconnect();
                }
                catch (Exception e) {
                    logger.error("JSch channel disconnect error:", (Throwable)e);
                }
            }
        }
        return resultLines;
    }

    public static void connect(Session session) {
        if (session == null) {
            return;
        }
        try {
            session.connect(0);
            if (session.isConnected()) {
                logger.info("Host({}) connected.", (Object)session.getHost());
                return;
            }
        }
        catch (Exception e) {
            logger.error("JSch create session error:", (Throwable)e);
        }
        throw new RuntimeException(String.format("Host(%s) connection failed.", session.getHost()));
    }

    public static void close(Session session) {
        if (session == null) {
            return;
        }
        try {
            session.disconnect();
        }
        catch (Exception e) {
            logger.error("JSch channel disconnect error:", (Throwable)e);
        }
    }

    private static boolean isPrivateKeyFile(String input) throws IOException {
        File file = new File(input);
        if (file.exists() && file.isFile() && file.canRead()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                StringBuilder content = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    content.append(line).append("\n");
                }
                boolean bl = SshUtils.isPrivateKeyString(content.toString());
                return bl;
            }
        }
        return false;
    }

    private static boolean isPrivateKeyString(String input) {
        String trimmedInput = input.trim();
        return trimmedInput.startsWith("-----BEGIN PRIVATE KEY-----") && trimmedInput.endsWith("-----END PRIVATE KEY-----") || trimmedInput.startsWith("-----BEGIN RSA PRIVATE KEY-----") && trimmedInput.endsWith("-----END RSA PRIVATE KEY-----") || trimmedInput.startsWith("-----BEGIN OPENSSH PRIVATE KEY-----") && trimmedInput.endsWith("-----END OPENSSH PRIVATE KEY-----");
    }
}

