/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.license;

import com.digiwin.dap.middle.license.bean.LicenseEnv;
import com.digiwin.dap.middle.license.filter.LicenseCheckFilter;
import com.digiwin.dap.middle.license.support.LicenseHeartbeat;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnProperty(prefix="dap.middleware.license", value={"enabled"}, havingValue="true", matchIfMissing=true)
public class LicenseValidatorConfiguration {
    private static final String[] DEFAULT_URL_MAPPINGS = new String[]{"/api/dmc/v1/auth/login", "/api/iam/v2/identity/token/analyze"};

    @Bean
    public LicenseEnv licenseEnv() {
        return new LicenseEnv();
    }

    @Bean
    public LicenseHeartbeat licenseHeartbeat() {
        return new LicenseHeartbeat();
    }

    @Bean
    @ConditionalOnMissingBean(name={"licenseCheckFilter"})
    public FilterRegistrationBean<Filter> licenseCheckFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        LicenseCheckFilter filter = new LicenseCheckFilter();
        registrationBean.setFilter((Filter)filter);
        registrationBean.setOrder(filter.getOrder());
        registrationBean.addUrlPatterns(DEFAULT_URL_MAPPINGS);
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }
}

