/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.license.support;

import com.digiwin.dap.middle.license.bean.DeviceInfo;
import com.digiwin.dap.middle.license.bean.LicenseEnv;
import com.digiwin.dap.middle.license.jni.LicenseProcess;
import com.digiwin.dap.middle.license.processor.K8sProcessor;
import com.digiwin.dap.middle.license.processor.SshProcessor;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;

public class LicenseHeartbeat {
    public static final String VERIFY_KEY = "verified";
    public static final Map<String, String> VERIFY_RESULT = new HashMap<String, String>();
    private static final Logger logger = LoggerFactory.getLogger(LicenseHeartbeat.class);
    private static final long FIXED_PERIOD = 24L;
    @Autowired
    private LicenseEnv env;

    @Scheduled(fixedRate=24L, timeUnit=TimeUnit.HOURS)
    public void doHeartbeat() throws Exception {
        if (StrUtils.isEmpty((String)this.env.getLicense())) {
            VERIFY_RESULT.put(VERIFY_KEY, "dap.middleware.license.config.none");
            return;
        }
        ArrayList<DeviceInfo> deviceInfos = new ArrayList<DeviceInfo>();
        if (StrUtils.isNotEmpty((String)this.env.getHost())) {
            deviceInfos.add(SshProcessor.getDeviceInfo((String)this.env.getHost(), (int)this.env.getPort(), (String)this.env.getUsername(), (String)this.env.getPassword(), (String)this.env.getIdentity()));
        } else if ("Develop".equals(this.env.getDeployArea())) {
            deviceInfos.add(LicenseProcess.getDeviceInfo());
        } else {
            deviceInfos.addAll(K8sProcessor.getNodeInfo((String)this.env.getAppName()));
        }
        if (deviceInfos.isEmpty()) {
            VERIFY_RESULT.put(VERIFY_KEY, "dap.middleware.license.obtain.machine.none");
            return;
        }
        boolean verified = this.verify(deviceInfos);
        if (!verified) {
            VERIFY_RESULT.put(VERIFY_KEY, "dap.middleware.license.check.fail");
        }
    }

    private boolean verify(List<DeviceInfo> deviceInfos) {
        for (DeviceInfo deviceInfo : deviceInfos) {
            try {
                String machineCode = LicenseProcess.getMachineCode(new DeviceInfo[]{deviceInfo});
                String verifyResult = LicenseProcess.verifyLicense(machineCode, this.env.getLicense());
                if (!"PASS".equals(verifyResult)) continue;
                return true;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }
}

