package com.digiwin.dap.middleware.mojo;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.DirectoryScanner;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

/**
 * 删除Maven仓库下，目录/com/digiwin/dap/middleware中，指定版本的文件
 *
 * @author fobgochod
 * @date 2022/3/4 11:01
 */
@Mojo(name = "remove-local-jar")
public class RemoveLocalJarMojo extends AbstractDapMojo {

    @Parameter(property = "dapwareVersion", defaultValue = "2.7.0")
    private String dapwareVersion;
    @Parameter(defaultValue = "${project}")
    private MavenProject mavenProject;
    @Parameter(defaultValue = "${settings}", readonly = true)
    private Settings settings;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.deleteJar();
    }

    private void deleteJar() {
        String basePath = settings.getLocalRepository() + "/com/digiwin/dap/middleware/";
        final DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(new File(basePath));
        scanner.scan();

        for (String included : scanner.getIncludedFiles()) {
            final Path source = Paths.get(basePath).resolve(included);
            File file = source.toFile();
            if (file.getParentFile().getName().equals(dapwareVersion)
                    || file.getAbsolutePath().contains("pagehelper")) {
                if (file.delete()) {
                    getLog().info(String.format("Deleting %s", file.getAbsolutePath()));
                } else {
                    getLog().info(String.format("Deleted fail %s", file.getAbsolutePath()));
                }
            }
        }
    }
}
