/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.mojo;

import com.digiwin.dap.middleware.mojo.AbstractDapMojo;
import com.digiwin.dap.middleware.ssh.DockerUtils;
import com.digiwin.dap.middleware.ssh.Shell;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="remove-container")
public class RemoveContainerMojo
extends AbstractDapMojo {
    @Parameter(property="startFile", defaultValue="doc/run/startup.sh")
    private String startFile;

    public void execute() throws MojoExecutionException {
        try {
            List<String> dockers = Files.readAllLines(Paths.get(this.startFile, new String[0]));
            Optional<String> dockerRunPort = dockers.stream().filter(p -> p.startsWith("PORT")).findFirst();
            Optional<String> dockerRunName = dockers.stream().filter(p -> p.startsWith("NAME")).findFirst();
            if (dockerRunPort.isPresent() && dockerRunName.isPresent()) {
                String appPort = dockerRunPort.get().replace("PORT=", "");
                String appName = dockerRunName.get().replace("NAME=", "").replace("$PORT", appPort);
                DockerUtils.instance(new Shell(this.host, this.port, this.username, this.password)).removeContainer(appName);
                this.getLog().info((CharSequence)String.format("\u5220\u9664\u5bb9\u5668\uff1a%s", appName));
            }
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)"\u5220\u9664\u5bb9\u5668\u5931\u8d25\uff0c\u8bf7\u81ea\u884c\u8fde\u63a5\u670d\u52a1\u5668\u624b\u52a8\u5220\u9664\u3002");
        }
    }
}

