/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

public class ScpUtil {
    private static final Log logger = new SystemStreamLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long scpTo(Session session, String source, String destination) {
        logger.debug((CharSequence)String.format(">> cp %s %s", source, destination));
        FileInputStream fis = null;
        try {
            int len;
            ChannelExec channel = (ChannelExec)session.openChannel("exec");
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            boolean ptimestamp = false;
            Object command = "scp";
            if (ptimestamp) {
                command = (String)command + " -p";
            }
            command = (String)command + " -t " + destination;
            channel.setCommand((String)command);
            channel.connect(0);
            if (ScpUtil.checkAck(in) != 0) {
                long l = -1L;
                return l;
            }
            File _lfile = new File(source);
            if (ptimestamp) {
                command = "T " + _lfile.lastModified() / 1000L + " 0";
                command = (String)command + " " + _lfile.lastModified() / 1000L + " 0\n";
                out.write(((String)command).getBytes());
                out.flush();
                if (ScpUtil.checkAck(in) != 0) {
                    long l = -1L;
                    return l;
                }
            }
            long fileSize = _lfile.length();
            command = "C0644 " + fileSize + " ";
            command = source.lastIndexOf(47) > 0 ? (String)command + source.substring(source.lastIndexOf(47) + 1) : (String)command + source;
            command = (String)command + "\n";
            out.write(((String)command).getBytes());
            out.flush();
            if (ScpUtil.checkAck(in) != 0) {
                long e = -1L;
                return e;
            }
            fis = new FileInputStream(source);
            byte[] buf = new byte[1024];
            long sum = 0L;
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
                sum += (long)len;
            }
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            if (ScpUtil.checkAck(in) != 0) {
                long l = -1L;
                return l;
            }
            long l = sum;
            return l;
        }
        catch (JSchException e) {
            logger.error((CharSequence)"scp to catched jsch exception, ", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((CharSequence)"scp to catched io exception, ", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((CharSequence)"scp to error, ", (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    logger.error((CharSequence)"File input stream close error, ", (Throwable)e);
                }
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long scpFrom(Session session, String source, String destination) {
        logger.debug((CharSequence)String.format(">> cp %s %s", source, destination));
        FileOutputStream fis = null;
        try {
            int len;
            ChannelExec channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand("scp -f " + source);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] buf = new byte[1024];
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            while (ScpUtil.checkAck(in) == 67) {
            }
            in.read(buf, 0, 4);
            long fileSize = 0L;
            while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                fileSize = fileSize * 10L + (long)(buf[0] - 48);
            }
            String file = null;
            int i = 0;
            while (true) {
                in.read(buf, i, 1);
                if (buf[i] == 10) break;
                ++i;
            }
            file = new String(buf, 0, i);
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            fis = Files.isDirectory(Paths.get(destination, new String[0]), new LinkOption[0]) ? new FileOutputStream(destination + File.separator + file) : new FileOutputStream(destination);
            long sum = 0L;
            while ((len = in.read(buf, 0, buf.length)) > 0) {
                sum += (long)len;
                if ((long)len >= fileSize) {
                    fis.write(buf, 0, (int)fileSize);
                    break;
                }
                fis.write(buf, 0, len);
                fileSize -= (long)len;
            }
            long l = sum;
            return l;
        }
        catch (JSchException e) {
            logger.error((CharSequence)"scp to catched jsch exception, ", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((CharSequence)"scp to catched io exception, ", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((CharSequence)"scp to error, ", (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    logger.error((CharSequence)"File output stream close error, ", (Throwable)e);
                }
            }
        }
        return -1L;
    }

    private static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0 || b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                System.out.print(sb.toString());
            }
            if (b == 2) {
                System.out.print(sb.toString());
            }
        }
        return b;
    }
}

